/*
 * Decompiled with CFR 0.152.
 */
package io.activej.trigger;

import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.MBeanFormat;
import java.time.Instant;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class TriggerResult
implements WithInitializer<TriggerResult> {
    private static final TriggerResult NONE = new TriggerResult(0L, null, null);
    private final long timestamp;
    private final Throwable throwable;
    private final Object value;
    private final int count;

    TriggerResult(long timestamp, @Nullable Throwable e, @Nullable Object value, int count) {
        this.timestamp = timestamp;
        this.throwable = e;
        this.value = value;
        this.count = count;
    }

    TriggerResult(long timestamp, @Nullable Throwable e, @Nullable Object context) {
        this(timestamp, e, context, 1);
    }

    public static TriggerResult none() {
        return NONE;
    }

    public static TriggerResult create() {
        return new TriggerResult(0L, null, null);
    }

    public static TriggerResult create(long timestamp, Throwable e, int count) {
        return new TriggerResult(timestamp, e, null, count);
    }

    public static TriggerResult create(long timestamp, @Nullable Throwable e, @Nullable Object value) {
        return new TriggerResult(timestamp, e, value);
    }

    public static TriggerResult create(long timestamp, Throwable e, Object value, int count) {
        return new TriggerResult(timestamp, e, value, count);
    }

    public static TriggerResult create(Instant instant, @Nullable Throwable e, @Nullable Object value) {
        return TriggerResult.create(instant.toEpochMilli(), e, value);
    }

    public static TriggerResult create(Instant instant, Throwable e, Object value, int count) {
        return TriggerResult.create(instant.toEpochMilli(), e, value, count);
    }

    public static TriggerResult ofTimestamp(long timestamp) {
        return timestamp != 0L ? new TriggerResult(timestamp, null, null) : NONE;
    }

    public static TriggerResult ofTimestamp(long timestamp, boolean condition) {
        return timestamp != 0L && condition ? new TriggerResult(timestamp, null, null) : NONE;
    }

    public static TriggerResult ofInstant(@Nullable Instant instant) {
        return instant != null ? TriggerResult.create(instant, null, null) : NONE;
    }

    public static TriggerResult ofInstant(Instant instant, boolean condition) {
        return instant != null && condition ? TriggerResult.create(instant, null, null) : NONE;
    }

    public static TriggerResult ofError(Throwable e) {
        return e != null ? new TriggerResult(0L, e, null) : NONE;
    }

    public static TriggerResult ofError(Throwable e, long timestamp) {
        return e != null ? new TriggerResult(timestamp, e, null) : NONE;
    }

    public static TriggerResult ofError(Throwable e, Instant instant) {
        return e != null ? TriggerResult.create(instant.toEpochMilli(), e, null) : NONE;
    }

    public static TriggerResult ofError(ExceptionStats exceptionStats) {
        Throwable lastException = exceptionStats.getLastException();
        return lastException != null ? TriggerResult.create(exceptionStats.getLastTime() != null ? exceptionStats.getLastTime().toEpochMilli() : 0L, lastException, exceptionStats.getTotal()) : NONE;
    }

    public static TriggerResult ofValue(Object value) {
        return value != null ? new TriggerResult(0L, null, value) : NONE;
    }

    public static <T> TriggerResult ofValue(T value, Predicate<T> predicate) {
        return value != null && predicate.test(value) ? new TriggerResult(0L, null, value) : NONE;
    }

    public static <T> TriggerResult ofValue(T value, boolean condition) {
        return value != null && condition ? new TriggerResult(0L, null, value) : NONE;
    }

    public static <T> TriggerResult ofValue(Supplier<T> supplier, boolean condition) {
        return condition ? TriggerResult.ofValue(supplier.get()) : NONE;
    }

    public TriggerResult withValue(Object value) {
        return this.isPresent() ? new TriggerResult(this.timestamp, this.throwable, value) : NONE;
    }

    public TriggerResult withValue(Supplier<?> value) {
        return this.isPresent() ? new TriggerResult(this.timestamp, this.throwable, value.get()) : NONE;
    }

    public TriggerResult withCount(int count) {
        return this.isPresent() ? new TriggerResult(this.timestamp, this.throwable, this.value, count) : NONE;
    }

    public TriggerResult withCount(IntSupplier count) {
        return this.isPresent() ? new TriggerResult(this.timestamp, this.throwable, this.value, count.getAsInt()) : NONE;
    }

    public TriggerResult when(boolean condition) {
        return this.isPresent() && condition ? this : NONE;
    }

    public TriggerResult when(BooleanSupplier conditionSupplier) {
        return this.isPresent() && conditionSupplier.getAsBoolean() ? this : NONE;
    }

    public <T> TriggerResult whenValue(Predicate<T> valuePredicate) {
        return this.isPresent() && this.hasValue() && valuePredicate.test(this.value) ? this : NONE;
    }

    public boolean isPresent() {
        return this != NONE;
    }

    public boolean hasTimestamp() {
        return this.timestamp != 0L;
    }

    public boolean hasThrowable() {
        return this.throwable != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public long getTimestamp() {
        Checks.checkState((boolean)this.isPresent(), (Object)"Trigger is not present");
        return this.timestamp;
    }

    @Nullable
    public Instant getInstant() {
        Checks.checkState((boolean)this.isPresent(), (Object)"Trigger is not present");
        return this.hasTimestamp() ? Instant.ofEpochMilli(this.timestamp) : null;
    }

    @Nullable
    public Throwable getThrowable() {
        Checks.checkState((boolean)this.isPresent(), (Object)"Trigger is not present");
        return this.throwable;
    }

    @Nullable
    public Object getValue() {
        Checks.checkState((boolean)this.isPresent(), (Object)"Trigger is not present");
        return this.value;
    }

    public int getCount() {
        Checks.checkState((boolean)this.isPresent(), (Object)"Trigger is not present");
        return this.count;
    }

    public String toString() {
        return "@" + Instant.ofEpochMilli(this.timestamp) + (this.count != 1 ? " #" + this.count : "") + (this.value != null ? " : " + this.value : "") + (this.throwable != null ? "\n" + MBeanFormat.formatExceptionMultiline((Throwable)this.throwable) : "");
    }
}

