/*
 * Decompiled with CFR 0.152.
 */
package io.activej.worker;

import io.activej.inject.Injector;
import io.activej.inject.Key;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.module.AbstractModule;
import io.activej.worker.WorkerPool;
import io.activej.worker.WorkerPools;
import io.activej.worker.annotation.Worker;
import io.activej.worker.annotation.WorkerId;
import java.lang.annotation.Annotation;

public final class WorkerPoolModule
extends AbstractModule {
    private final Class<? extends Annotation>[] workerScopes;

    @SafeVarargs
    private WorkerPoolModule(Class<? extends Annotation> ... workerScopes) {
        this.workerScopes = workerScopes;
    }

    public static WorkerPoolModule create() {
        return new WorkerPoolModule(Worker.class);
    }

    @SafeVarargs
    public static WorkerPoolModule create(Class<? extends Annotation> ... workerScopes) {
        return new WorkerPoolModule(workerScopes);
    }

    protected void configure() {
        this.bind(WorkerPools.class).to(WorkerPools::new, Injector.class);
        for (Class<? extends Annotation> scope2 : this.workerScopes) {
            this.bind(Integer.TYPE, WorkerId.class).in(scope2, new Class[0]).to(() -> {
                throw new AssertionError((Object)"Worker ID constructor must never be called since it's instance is always put in the cache manually");
            });
        }
        this.generate(WorkerPool.Instances.class, (bindings, scope, key) -> {
            Key requestedKey = key.getTypeParameter(0);
            return Binding.to(wp -> wp.getInstances(requestedKey), (Key)Key.of(WorkerPool.class, (Object)key.getQualifier())).as(BindingType.EAGER);
        });
    }
}

