/*
 * Decompiled with CFR 0.152.
 */
package io.activej.worker;

import io.activej.inject.Injector;
import io.activej.inject.Scope;
import io.activej.worker.WorkerPool;
import io.activej.worker.annotation.Worker;
import java.util.ArrayList;
import java.util.List;

public final class WorkerPools {
    private final Injector injector;
    private final List<WorkerPool> workerPools = new ArrayList<WorkerPool>();

    WorkerPools(Injector injector) {
        this.injector = injector;
    }

    public synchronized WorkerPool createPool(int size) {
        return this.createPool(Scope.of(Worker.class), size);
    }

    public synchronized WorkerPool createPool(Scope scope, int size) {
        WorkerPool workerPool = new WorkerPool(this.injector, this.workerPools.size(), scope, size);
        this.workerPools.add(workerPool);
        return workerPool;
    }

    public List<WorkerPool> getWorkerPools() {
        return new ArrayList<WorkerPool>(this.workerPools);
    }

    public int size() {
        return this.workerPools.size();
    }
}

