/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.command.UsageHelper;
import io.airlift.command.UsagePrinter;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class CommandUsage {
    private final int columnSize;
    private final Comparator<? super OptionMetadata> optionComparator;

    public CommandUsage() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandUsage(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandUsage(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
        this.optionComparator = optionComparator;
    }

    public void usage(@Nullable String programName, @Nullable String groupName, CommandMetadata command) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(programName, groupName, command, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public void usage(@Nullable String programName, @Nullable String groupName, CommandMetadata command, StringBuilder out) {
        this.usage(programName, groupName, command, new UsagePrinter(out, this.columnSize));
    }

    public void usage(@Nullable String programName, @Nullable String groupName, CommandMetadata command, UsagePrinter out) {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(programName).append(groupName).append(command.getName()).append("-").append(command.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            synopsis.append(programName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            synopsis.append(groupName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(command.getName()).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            synopsis.append("[--]").append(UsageHelper.toUsage(arguments));
        }
        synopsis.newline();
        synopsis.newline();
        if (options.size() > 0 || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            out.append("OPTIONS").newline();
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(UsageHelper.toDescription(optionMetadata)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(optionMetadata.getDescription()).newline();
                descriptionPrinter.newline();
            }
            if (arguments != null) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append("--").newline();
                UsagePrinter usagePrinter = optionPrinter.newIndentedPrinter(4);
                usagePrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options").newline();
                usagePrinter.newline();
                optionPrinter.append(UsageHelper.toDescription(arguments)).newline();
                usagePrinter.append(arguments.getDescription()).newline();
                usagePrinter.newline();
            }
        }
    }

    private List<OptionMetadata> sortOptions(List<OptionMetadata> options) {
        if (this.optionComparator != null) {
            options = new ArrayList<OptionMetadata>(options);
            Collections.sort(options, this.optionComparator);
        }
        return options;
    }
}

