/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.kernel.handles.Handle;
import io.apigee.trireme.node10.modules.JavaStreamWrap;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;

public class ConsoleWrap
implements InternalNodeModule {
    public static final String MODULE_NAME = "console_wrap";
    public static final int DEFAULT_WINDOW_COLS = 80;
    public static final int DEFAULT_WINDOW_ROWS = 24;

    public String getModuleName() {
        return MODULE_NAME;
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable exports = cx.newObject(scope);
        exports.setPrototype(scope);
        exports.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)exports, JavaStreamWrap.StreamWrapImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, ConsoleWrapImpl.class, (boolean)false, (boolean)true);
        return exports;
    }

    public static class ConsoleWrapImpl
    extends JavaStreamWrap.StreamWrapImpl {
        public static final String CLASS_NAME = "Console";

        public String getClassName() {
            return CLASS_NAME;
        }

        protected ConsoleWrapImpl(Handle handle, ScriptRunner runtime) {
            super(handle, runtime);
        }

        public ConsoleWrapImpl() {
        }

        @JSConstructor
        public static Object construct(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            if (!inNewExpr) {
                return cx.newObject((Scriptable)ctorObj, CLASS_NAME);
            }
            ScriptRunner runtime = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            Handle handle = (Handle)ArgUtils.objArg((Object[])args, (int)0, Handle.class, (boolean)true);
            return new ConsoleWrapImpl(handle, runtime);
        }

        @JSGetter(value="isTTY")
        public boolean isTty() {
            return true;
        }

        @JSFunction
        public static void setRawMode(Context cx, Scriptable thisObj, Object[] args, Function func) {
            throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"Raw mode is not supported in Trireme.");
        }

        @JSFunction
        public static void getWindowSize(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Scriptable s = (Scriptable)ArgUtils.objArg((Object[])args, (int)0, Scriptable.class, (boolean)true);
            int columns = 80;
            String cols = System.getenv("COLUMNS");
            if (cols != null) {
                try {
                    columns = Integer.parseInt(cols);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            s.put(0, s, (Object)columns);
            int rows = 24;
            String rowStr = System.getenv("LINES");
            if (rowStr != null) {
                try {
                    rows = Integer.parseInt(rowStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            s.put(1, s, (Object)rows);
        }
    }
}

