/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.AbstractFilesystem;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.fs.BasicFilesystem;
import io.apigee.trireme.kernel.fs.FileStats;
import io.apigee.trireme.node10.modules.StatWatcher;
import io.apigee.trireme.node10.modules.StatsImpl;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filesystem
implements InternalNodeModule {
    private static final Logger log = LoggerFactory.getLogger(Filesystem.class);

    public String getModuleName() {
        return "fs";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, FSImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)scope, StatsImpl.class, (boolean)false, (boolean)true);
        FSImpl fs2 = (FSImpl)cx.newObject(scope, "_fsClassNode10Sync");
        fs2.initialize(runner, runner.getAsyncPool());
        ScriptableObject.defineClass((Scriptable)fs2, StatsImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)fs2, StatWatcher.class, (boolean)false, (boolean)true);
        return fs2;
    }

    private static abstract class AsyncAction {
        private AsyncAction() {
        }

        public abstract Object[] execute() throws OSException;

        public Object[] mapException(Context cx, Scriptable scope, OSException e) {
            return new Object[]{Utils.makeErrorObject((Context)cx, (Scriptable)scope, (OSException)e)};
        }

        public Object[] mapSyncException(OSException e) {
            return null;
        }
    }

    public static class FSImpl
    extends ScriptableObject
    implements AbstractFilesystem {
        public static final String CLASS_NAME = "_fsClassNode10Sync";
        protected ScriptRunner runner;
        protected Executor pool;
        private BasicFilesystem fs;

        public String getClassName() {
            return CLASS_NAME;
        }

        protected void initialize(NodeRuntime runner, Executor fsPool) {
            this.runner = (ScriptRunner)runner;
            this.pool = fsPool;
            this.fs = this.runner.getFilesystem();
        }

        public void cleanup() {
            this.fs.cleanup();
        }

        private Object runAction(final Context cx, final Function callback, final AsyncAction action) {
            if (callback == null) {
                try {
                    Object[] ret = action.execute();
                    if (ret == null || ret.length < 2) {
                        return null;
                    }
                    return ret[1];
                }
                catch (OSException e) {
                    Object[] err;
                    if (log.isDebugEnabled()) {
                        log.debug("I/O exception: {}: {}", (Object)e.getCode(), (Object)e);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace(e.toString(), (Throwable)e);
                    }
                    if ((err = action.mapSyncException(e)) == null) {
                        throw Utils.makeError((Context)cx, (Scriptable)this, (OSException)e);
                    }
                    return err[1];
                }
            }
            final FSImpl self = this;
            final Object domain2 = this.runner.getDomain();
            this.runner.pin();
            this.pool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (log.isTraceEnabled()) {
                        log.trace("Executing async action {}", (Object)action);
                    }
                    try {
                        Object[] args = action.execute();
                        if (args == null) {
                            args = new Object[]{};
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Calling {} with {}", (Object)((BaseFunction)callback).getFunctionName(), (Object)args);
                        }
                        FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain2, args);
                    }
                    catch (OSException e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Async action {} failed: {}: {}", new Object[]{action, e.getCode(), e});
                        }
                        FSImpl.this.runner.enqueueCallback(callback, (Scriptable)callback, null, domain2, action.mapException(cx, (Scriptable)self, e));
                    }
                    finally {
                        FSImpl.this.runner.unPin();
                    }
                }
            });
            return null;
        }

        private File translatePath(String path2) throws OSException {
            File trans = this.runner.translatePath(path2);
            if (trans == null) {
                throw new OSException(-2);
            }
            return trans;
        }

        private static Buffer.BufferImpl ensureBuffer(Context cx, Scriptable scope, Object[] args, int pos) {
            ArgUtils.ensureArg((Object[])args, (int)pos);
            try {
                return (Buffer.BufferImpl)args[pos];
            }
            catch (ClassCastException cce) {
                throw Utils.makeError((Context)cx, (Scriptable)scope, (String)"Not a buffer", (String)"EINVAL");
            }
        }

        @JSFunction
        public static Object open(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final String pathStr = ArgUtils.stringArg((Object[])args, (int)0);
            final int flags = ArgUtils.intArg((Object[])args, (int)1);
            final int mode = ArgUtils.intArg((Object[])args, (int)2);
            Function callback = ArgUtils.functionArg((Object[])args, (int)3, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File path2 = fs2.translatePath(pathStr);
                    int fd = fs2.fs.open(path2, pathStr, flags, mode, fs2.runner.getProcess().getUmask());
                    return new Object[]{Undefined.instance, fd};
                }

                public Object[] mapException(Context cx, Scriptable scope, OSException e) {
                    return new Object[]{Utils.makeErrorObject((Context)cx, (Scriptable)thisObj, (OSException)e)};
                }
            });
        }

        @JSFunction
        public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    fs2.fs.close(fd);
                    return null;
                }
            });
        }

        @JSFunction
        public static Object read(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            final Buffer.BufferImpl buf = FSImpl.ensureBuffer(cx, thisObj, args, 1);
            int off = ArgUtils.intArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)2, (int)0);
            int len = ArgUtils.intArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)3, (int)0);
            long pos = ArgUtils.longArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)4, (long)-1L);
            Function callback = ArgUtils.functionArg((Object[])args, (int)5, (boolean)false);
            if (off >= buf.getLength()) {
                throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"Offset is out of bounds", (String)"EINVAL");
            }
            if (off + len > buf.getLength()) {
                throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"Length extends beyond buffer", (String)"EINVAL");
            }
            byte[] bytes = buf.getArray();
            int bytesOffset = buf.getArrayOffset() + off;
            final ByteBuffer readBuf = ByteBuffer.wrap(bytes, bytesOffset, len);
            if (pos < 0L) {
                try {
                    pos = fs2.fs.getPosition(fd);
                }
                catch (OSException oSException) {
                    // empty catch block
                }
            }
            final long readPos = pos;
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    int count = fs2.fs.read(fd, readBuf, readPos);
                    fs2.fs.updatePosition(fd, count);
                    return new Object[]{Undefined.instance, count, buf};
                }

                public Object[] mapException(Context cx, Scriptable scope, OSException e) {
                    return new Object[]{Utils.makeErrorObject((Context)cx, (Scriptable)thisObj, (OSException)e), 0, buf};
                }
            });
        }

        @JSFunction
        public static Object write(Context cx, final Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            final Buffer.BufferImpl buf = FSImpl.ensureBuffer(cx, thisObj, args, 1);
            int off = ArgUtils.intArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)2, (int)0);
            final int len = ArgUtils.intArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)3, (int)0);
            long pos = ArgUtils.longArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)4, (long)0L);
            Function callback = ArgUtils.functionArg((Object[])args, (int)5, (boolean)false);
            if (off >= buf.getLength()) {
                throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"Offset is out of bounds", (String)"EINVAL");
            }
            if (off + len > buf.getLength()) {
                throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)"Length extends beyond buffer", (String)"EINVAL");
            }
            byte[] bytes = buf.getArray();
            int bytesOffset = buf.getArrayOffset() + off;
            final ByteBuffer writeBuf = ByteBuffer.wrap(bytes, bytesOffset, len);
            if (pos <= 0L) {
                try {
                    pos = fs2.fs.updatePosition(fd, len);
                }
                catch (OSException oSException) {
                    // empty catch block
                }
            }
            final long writePos = pos;
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    fs2.fs.write(fd, writeBuf, writePos);
                    return new Object[]{Undefined.instance, len, buf};
                }

                public Object[] mapException(Context cx, Scriptable scope, OSException e) {
                    return new Object[]{Utils.makeErrorObject((Context)cx, (Scriptable)thisObj, (OSException)e), 0, buf};
                }
            });
        }

        @JSFunction
        public static void fsync(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    fs2.fs.fsync(fd, true);
                    return null;
                }
            });
        }

        @JSFunction
        public static void fdatasync(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    fs2.fs.fsync(fd, false);
                    return null;
                }
            });
        }

        @JSFunction
        public static void rename(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String oldPath = ArgUtils.stringArg((Object[])args, (int)0);
            final String newPath = ArgUtils.stringArg((Object[])args, (int)1);
            Function callback = ArgUtils.functionArg((Object[])args, (int)2, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File oldFile = fs2.translatePath(oldPath);
                    File newFile = fs2.translatePath(newPath);
                    fs2.fs.rename(oldFile, oldPath, newFile, newPath);
                    return null;
                }
            });
        }

        @JSFunction
        public static void ftruncate(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            final long len = ArgUtils.longArgOnly((Context)cx, (Scriptable)fs2, (Object[])args, (int)1, (long)0L);
            Function callback = ArgUtils.functionArg((Object[])args, (int)2, (boolean)false);
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    fs2.fs.ftruncate(fd, len);
                    return null;
                }
            });
        }

        @JSFunction
        public static void rmdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File file = fs2.translatePath(path2);
                    fs2.fs.rmdir(file, path2);
                    return null;
                }
            });
        }

        @JSFunction
        public static void unlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File file = fs2.translatePath(path2);
                    fs2.fs.unlink(file, path2);
                    return null;
                }
            });
        }

        @JSFunction
        public static void mkdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            final int mode = ArgUtils.intArg((Object[])args, (int)1);
            Function callback = ArgUtils.functionArg((Object[])args, (int)2, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File file = fs2.translatePath(path2);
                    fs2.fs.mkdir(file, path2, mode, fs2.runner.getProcess().getUmask());
                    return null;
                }
            });
        }

        @JSFunction
        public static Object readdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    return fs2.doReaddir(path2);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doReaddir(String dn) throws OSException {
            File f = this.translatePath(dn);
            List files = this.fs.readdir(f, dn);
            Object[] objs = files.toArray(new Object[files.size()]);
            Context cx = Context.enter();
            try {
                Scriptable fileList = cx.newArray((Scriptable)this, objs);
                Object[] objectArray = new Object[]{Undefined.instance, fileList};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static Object stat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    return fs2.doStat(path2, false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doStat(String fn, boolean noFollow) throws OSException {
            Context cx = Context.enter();
            try {
                File f = this.translatePath(fn);
                FileStats stats = this.fs.stat(f, fn, noFollow);
                StatsImpl s = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
                s.setAttributes(cx, stats);
                if (log.isTraceEnabled()) {
                    log.trace("stat {} = {}", (Object)f.getPath(), (Object)s);
                }
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), s};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static Object lstat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            final FSImpl fs2 = (FSImpl)thisObj;
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    return fs2.doStat(path2, true);
                }
            });
        }

        @JSFunction
        public static Object fstat(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final FSImpl fs2 = (FSImpl)thisObj;
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            return fs2.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    return fs2.doFStat(fd);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] doFStat(int fd) throws OSException {
            Context cx = Context.enter();
            try {
                FileStats stats = this.fs.fstat(fd, false);
                StatsImpl s = (StatsImpl)cx.newObject((Scriptable)this, "Stats");
                s.setAttributes(cx, stats);
                Object[] objectArray = new Object[]{Context.getUndefinedValue(), s};
                return objectArray;
            }
            finally {
                Context.exit();
            }
        }

        @JSFunction
        public static void utimes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            final double atime = ArgUtils.doubleArg((Object[])args, (int)1);
            final double mtime = ArgUtils.doubleArg((Object[])args, (int)2);
            Function callback = ArgUtils.functionArg((Object[])args, (int)3, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File f = self.translatePath(path2);
                    long mtimeL = (long)(mtime * 1000.0);
                    long atimeL = (long)(atime * 1000.0);
                    self.fs.utimes(f, path2, mtimeL, atimeL);
                    return new Object[]{Undefined.instance, Undefined.instance};
                }
            });
        }

        @JSFunction
        public static void futimes(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            final double atime = ArgUtils.doubleArg((Object[])args, (int)1);
            final double mtime = ArgUtils.doubleArg((Object[])args, (int)2);
            Function callback = ArgUtils.functionArg((Object[])args, (int)3, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    long mtimeL = (long)(mtime * 1000.0);
                    long atimeL = (long)(atime * 1000.0);
                    self.fs.futimes(fd, atimeL, mtimeL);
                    return new Object[]{Undefined.instance, Undefined.instance};
                }
            });
        }

        @JSFunction
        public static void chmod(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            final int mode = ArgUtils.intArg((Object[])args, (int)1);
            Function callback = ArgUtils.functionArg((Object[])args, (int)2, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File f = self.translatePath(path2);
                    self.fs.chmod(f, path2, mode, self.runner.getProcess().getUmask(), false);
                    return null;
                }
            });
        }

        @JSFunction
        public static void fchmod(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            final int mode = ArgUtils.intArg((Object[])args, (int)1);
            Function callback = ArgUtils.functionArg((Object[])args, (int)2, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    self.fs.fchmod(fd, mode, self.runner.getProcess().getUmask());
                    return null;
                }
            });
        }

        @JSFunction
        public static void chown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            final String uid = ArgUtils.stringArg((Object[])args, (int)1);
            final String gid = ArgUtils.stringArg((Object[])args, (int)2);
            Function callback = ArgUtils.functionArg((Object[])args, (int)3, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File file = self.translatePath(path2);
                    self.fs.chown(file, path2, uid, gid, false);
                    return new Object[]{Undefined.instance, Undefined.instance};
                }
            });
        }

        @JSFunction
        public static void fchown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final int fd = ArgUtils.intArg((Object[])args, (int)0);
            final String uid = ArgUtils.stringArg((Object[])args, (int)1);
            final String gid = ArgUtils.stringArg((Object[])args, (int)2);
            Function callback = ArgUtils.functionArg((Object[])args, (int)3, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    self.fs.fchown(fd, uid, gid, false);
                    return new Object[]{Undefined.instance, Undefined.instance};
                }
            });
        }

        @JSFunction
        public static Object link(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String targetPath = ArgUtils.stringArg((Object[])args, (int)0);
            final String linkPath = ArgUtils.stringArg((Object[])args, (int)1);
            Function callback = ArgUtils.functionArg((Object[])args, (int)2, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            return self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File targetFile = self.translatePath(targetPath);
                    File linkFile = self.translatePath(linkPath);
                    self.fs.link(targetFile, targetPath, linkFile, linkPath);
                    return new Object[]{Undefined.instance, Undefined.instance};
                }
            });
        }

        @JSFunction
        public static Object symlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String srcPath = ArgUtils.stringArg((Object[])args, (int)0);
            final String destPath = ArgUtils.stringArg((Object[])args, (int)1);
            String type = ArgUtils.stringArg((Object[])args, (int)2, null);
            Function callback = ArgUtils.functionArg((Object[])args, (int)3, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            return self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File srcFile = self.translatePath(srcPath);
                    File destFile = self.translatePath(destPath);
                    self.fs.symlink(destFile, destPath, srcFile, srcPath);
                    return new Object[]{Undefined.instance, Undefined.instance};
                }
            });
        }

        @JSFunction
        public static Object readlink(Context cx, Scriptable thisObj, Object[] args, Function func) {
            final String path2 = ArgUtils.stringArg((Object[])args, (int)0);
            Function callback = ArgUtils.functionArg((Object[])args, (int)1, (boolean)false);
            final FSImpl self = (FSImpl)thisObj;
            return self.runAction(cx, callback, new AsyncAction(){

                public Object[] execute() throws OSException {
                    File file = self.translatePath(path2);
                    String target = self.fs.readlink(file, path2);
                    return new Object[]{Undefined.instance, target};
                }
            });
        }
    }
}

