/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.AbstractProcess;
import io.apigee.trireme.core.internal.IdPropertyMap;
import io.apigee.trireme.core.internal.NodeExitException;
import io.apigee.trireme.core.internal.ProcessEnvironment;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.internal.TriremeProcess;
import io.apigee.trireme.kernel.GenericNodeRuntime;
import io.apigee.trireme.kernel.handles.AbstractHandle;
import io.apigee.trireme.kernel.handles.ConsoleHandle;
import io.apigee.trireme.kernel.handles.JavaInputStreamHandle;
import io.apigee.trireme.kernel.handles.JavaOutputStreamHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Process
implements NodeModule {
    public static final String MODULE_NAME = "process";
    protected static final Logger log = LoggerFactory.getLogger(Process.class);
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("^((.*[/\\\\])|([^/\\\\]*))(.+)\\.node$");

    public String getModuleName() {
        return MODULE_NAME;
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        new ProcessImpl().exportAsClass(scope);
        ScriptableObject.defineClass((Scriptable)scope, ProcessEnvironment.class, (boolean)false, (boolean)true);
        ProcessImpl exports = (ProcessImpl)cx.newObject(scope, "_processClass");
        exports.setRunner(runner);
        ProcessEnvironment env = (ProcessEnvironment)cx.newObject(scope, "_Environment");
        env.initialize(runner.getScriptObject().getEnvironment());
        exports.setEnv(env);
        return exports;
    }

    public static class ProcessImpl
    extends AbstractProcess {
        protected static final String CLASS_NAME = "_processClass";
        private static final IdPropertyMap props = new IdPropertyMap("_processClass");
        private static final int Id_binding = 2;
        private static final int Id_dlopen = 3;
        private static final int Id_abort = 4;
        private static final int Id_chdir = 5;
        private static final int Id_cwd = 6;
        private static final int Id_reallyExit = 7;
        private static final int Id_kill = 8;
        private static final int Id_send = 9;
        private static final int Id_disconnect = 10;
        private static final int Id_memoryUsage = 11;
        private static final int Id_pin = 12;
        private static final int Id_unpin = 13;
        private static final int Id_needTickCallback = 14;
        private static final int Id_umask = 15;
        private static final int Id_uptime = 16;
        private static final int Id_hrtime = 17;
        private static final int Prop_eval = 1;
        private static final int Prop_printEval = 2;
        private static final int Prop_forceRepl = 3;
        private static final int Prop_tickInfoBox = 4;
        private static final int Prop_connected = 5;
        private static final int Prop_childProcess = 6;
        private static final int Prop_stdoutHandle = 7;
        private static final int Prop_stderrHandle = 8;
        private static final int Prop_stdinHandle = 9;
        private static final int Prop_argv = 10;
        private static final int Prop_execArgv = 11;
        private static final int Prop_execPath = 12;
        private static final int Prop_env = 13;
        private static final int Prop_version = 14;
        private static final int Prop_versions = 15;
        private static final int Prop_config = 16;
        private static final int Prop_title = 17;
        private static final int Prop_arch = 18;
        private static final int Prop_pid = 19;
        private static final int Prop_errno = 20;
        private static final int Prop_platform = 21;
        private static final int Prop_submitTick = 22;
        private static final int Prop_emit = 23;
        private static final int Prop_tickCallback = 24;
        private static final int Prop_tickFromSpinner = 25;
        private static final int Prop_needImmediateCallback = 26;
        private static final int Prop_immediateCallback = 27;
        private static final int Prop_fatalException = 28;
        private static final int Prop_features = 29;
        private static final int Prop_domain = 30;
        private static final int Prop_exiting = 31;
        private static final int Prop_throwDeprecation = 32;
        private static final int Prop_traceDeprecation = 33;
        private Scriptable argv;
        private Function submitTick;
        private boolean needTickCallback;
        private Function tickSpinnerCallback;
        private Function tickCallback;
        private boolean needImmediateCallback;
        private Function immediateCallback;
        private Function fatalException;
        private Function emit;
        private Object domain;
        private boolean throwDeprecation;
        private boolean traceDeprecation;
        private Scriptable tickInfoBox;

        public ProcessImpl() {
            super(props);
        }

        protected ProcessImpl defaultConstructor(Context cx, Object[] args) {
            ProcessImpl p = new ProcessImpl();
            p.tickInfoBox = cx.newArray((Scriptable)this, 3);
            return p;
        }

        protected ProcessImpl defaultConstructor() {
            throw new AssertionError();
        }

        protected Object getInstanceIdValue(int id) {
            switch (id) {
                case 1: {
                    return this.eval;
                }
                case 2: {
                    return this.printEval;
                }
                case 3: {
                    return this.forceRepl;
                }
                case 4: {
                    return this.tickInfoBox;
                }
                case 5: {
                    return this.connected;
                }
                case 6: {
                    return this.runner.getScriptObject()._isChildProcess();
                }
                case 7: {
                    return this.getStdoutHandle();
                }
                case 8: {
                    return this.getStderrHandle();
                }
                case 9: {
                    return this.getStdinHandle();
                }
                case 10: {
                    return this.argv;
                }
                case 11: {
                    return this.getJSExecArgv();
                }
                case 12: {
                    return "./node";
                }
                case 13: {
                    return this.env;
                }
                case 14: {
                    return this.getVersion();
                }
                case 15: {
                    return this.getVersions();
                }
                case 16: {
                    return this.getConfig();
                }
                case 17: {
                    return "trireme";
                }
                case 18: {
                    return this.getArch();
                }
                case 19: {
                    return this.getPid();
                }
                case 20: {
                    return this.runner.getErrno();
                }
                case 21: {
                    return this.getPlatform();
                }
                case 22: {
                    return this.submitTick;
                }
                case 23: {
                    return this.emit;
                }
                case 24: {
                    return this.tickCallback;
                }
                case 25: {
                    return this.tickSpinnerCallback;
                }
                case 26: {
                    return this.needImmediateCallback;
                }
                case 27: {
                    return this.immediateCallback;
                }
                case 28: {
                    return this.fatalException;
                }
                case 29: {
                    return this.getFeatures(Context.getCurrentContext());
                }
                case 30: {
                    return this.domain;
                }
                case 31: {
                    return this.exiting;
                }
                case 32: {
                    return this.throwDeprecation;
                }
                case 33: {
                    return this.traceDeprecation;
                }
            }
            return super.getInstanceIdValue(id);
        }

        protected void setInstanceIdValue(int id, Object val) {
            switch (id) {
                case 1: {
                    this.eval = Context.toString((Object)val);
                    break;
                }
                case 2: {
                    this.printEval = Context.toBoolean((Object)val);
                    break;
                }
                case 3: {
                    this.forceRepl = Context.toBoolean((Object)val);
                    break;
                }
                case 5: {
                    this.connected = Context.toBoolean((Object)val);
                    break;
                }
                case 6: {
                    this.runner.getScriptObject()._setChildProcess(Context.toBoolean((Object)val));
                    break;
                }
                case 10: {
                    this.argv = (Scriptable)val;
                    break;
                }
                case 17: {
                    break;
                }
                case 22: {
                    this.submitTick = (Function)val;
                    break;
                }
                case 23: {
                    this.emit = (Function)val;
                    break;
                }
                case 24: {
                    this.tickCallback = (Function)val;
                    break;
                }
                case 25: {
                    this.tickSpinnerCallback = (Function)val;
                    break;
                }
                case 26: {
                    this.needImmediateCallback = Context.toBoolean((Object)val);
                    break;
                }
                case 27: {
                    this.immediateCallback = (Function)val;
                    break;
                }
                case 28: {
                    this.fatalException = (Function)val;
                    break;
                }
                case 30: {
                    this.domain = val;
                    break;
                }
                case 31: {
                    this.exiting = Context.toBoolean((Object)val);
                    break;
                }
                case 32: {
                    this.throwDeprecation = Context.toBoolean((Object)val);
                    break;
                }
                case 33: {
                    this.traceDeprecation = Context.toBoolean((Object)val);
                    break;
                }
                default: {
                    super.setInstanceIdValue(id, val);
                }
            }
        }

        protected Object prototypeCall(int id, Context cx, Scriptable scope, Object[] args) {
            switch (id) {
                case 2: {
                    return this.binding(cx, args);
                }
                case 5: {
                    this.chdir(cx, args);
                    break;
                }
                case 6: {
                    return this.cwd();
                }
                case 8: {
                    this.doKill(cx, args);
                    break;
                }
                case 9: {
                    this.send(cx, args);
                    break;
                }
                case 10: {
                    this.disconnect(cx);
                    break;
                }
                case 12: {
                    this.runner.pin();
                    break;
                }
                case 13: {
                    this.runner.unPin();
                    break;
                }
                case 14: {
                    this.needTickCallback = true;
                    break;
                }
                case 15: {
                    return this.umask(args);
                }
                case 16: {
                    return this.uptime();
                }
                default: {
                    return super.prototypeCall(id, cx, scope, args);
                }
            }
            return Undefined.instance;
        }

        protected Object anonymousCall(int id, Context cx, Scriptable scope, Object thisObj, Object[] args) {
            switch (id) {
                case 4: {
                    ProcessImpl.abort();
                    break;
                }
                case 3: {
                    ProcessImpl.dlopen(cx, args, (Scriptable)thisObj);
                    break;
                }
                case 7: {
                    ProcessImpl.reallyExit(args);
                    break;
                }
                case 11: {
                    return ProcessImpl.memoryUsage((Context)cx, (Scriptable)((Scriptable)thisObj));
                }
                case 17: {
                    return ProcessImpl.hrtime((Context)cx, (Object[])args, (Scriptable)((Scriptable)thisObj));
                }
            }
            return Undefined.instance;
        }

        public Object getDomain() {
            return this.domain;
        }

        public void setDomain(Object domain2) {
            this.domain = domain2;
        }

        private Object binding(Context cx, Object[] args) {
            String name = ArgUtils.stringArg((Object[])args, (int)0);
            return this.getInternalModule(name, cx);
        }

        public Object getInternalModule(String name, Context cx) {
            Object mod = this.runner.getCachedInternalModule(name);
            if (mod == null) {
                try {
                    mod = this.runner.initializeModule(name, AbstractModuleRegistry.ModuleType.INTERNAL, cx, this.runner.getScriptScope());
                    if (log.isTraceEnabled()) {
                        log.trace("Creating new instance {} of internal module {}", (Object)System.identityHashCode(mod), (Object)name);
                    }
                    if (mod == null && ("buffer".equals(name) || "native_module".equals(name))) {
                        return this.runner.require(name, cx);
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new EvaluatorException("Error initializing module: " + (targetException != null ? e.toString() + ": " + targetException.toString() : e.toString()));
                }
                catch (InstantiationException e) {
                    throw new EvaluatorException("Error initializing module: " + e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new EvaluatorException("Error initializing module: " + e.toString());
                }
                this.runner.cacheInternalModule(name, mod);
            } else if (log.isTraceEnabled()) {
                log.trace("Returning cached copy {} of internal module {}", (Object)System.identityHashCode(mod), (Object)name);
            }
            return mod;
        }

        private static void dlopen(Context cx, Object[] args, Scriptable thisObj) {
            Scriptable module2 = (Scriptable)ArgUtils.objArg((Object[])args, (int)0, Scriptable.class, (boolean)true);
            String fileName = ArgUtils.stringArg((Object[])args, (int)1);
            ScriptRunner runner = ProcessImpl.getRunner((Context)cx);
            Matcher m = FILE_NAME_PATTERN.matcher(fileName);
            if (!m.matches()) {
                throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)("dlopen(" + fileName + "): Native module not supported"));
            }
            String name = m.group(4);
            try {
                Object nativeMod = runner.initializeModule(name, AbstractModuleRegistry.ModuleType.NATIVE, cx, runner.getScriptScope());
                if (log.isTraceEnabled()) {
                    log.trace("Creating new instance {} of native module {}", (Object)System.identityHashCode(nativeMod), (Object)name);
                }
                if (nativeMod == null) {
                    throw Utils.makeError((Context)cx, (Scriptable)thisObj, (String)("dlopen(" + fileName + "): Native module not supported"));
                }
                module2.put("exports", module2, nativeMod);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw new EvaluatorException("Error initializing module: " + (targetException != null ? e.toString() + ": " + targetException.toString() : e.toString()));
            }
            catch (InstantiationException e) {
                throw new EvaluatorException("Error initializing module: " + e.toString());
            }
            catch (IllegalAccessException e) {
                throw new EvaluatorException("Error initializing module: " + e.toString());
            }
        }

        private Scriptable createStreamHandle(Context cx, AbstractHandle handle) {
            Scriptable module2 = (Scriptable)this.runner.requireInternal("java_stream_wrap", cx);
            return cx.newObject(module2, "JavaStream", new Object[]{handle});
        }

        private Scriptable createConsoleHandle(Context cx, AbstractHandle handle) {
            Scriptable module2 = (Scriptable)this.runner.requireInternal("console_wrap", cx);
            return cx.newObject(module2, "Console", new Object[]{handle});
        }

        private Object getStdoutHandle() {
            Context cx = Context.getCurrentContext();
            if (this.runner.getStdout() == System.out && ConsoleHandle.isConsoleSupported()) {
                ConsoleHandle streamHandle = new ConsoleHandle((GenericNodeRuntime)this.runner);
                return this.createConsoleHandle(cx, (AbstractHandle)streamHandle);
            }
            JavaOutputStreamHandle streamHandle = new JavaOutputStreamHandle(this.runner.getStdout());
            return this.createStreamHandle(cx, (AbstractHandle)streamHandle);
        }

        private Object getStderrHandle() {
            Context cx = Context.getCurrentContext();
            JavaOutputStreamHandle streamHandle = new JavaOutputStreamHandle(this.runner.getStderr());
            return this.createStreamHandle(cx, (AbstractHandle)streamHandle);
        }

        private Object getStdinHandle() {
            Context cx = Context.getCurrentContext();
            if (this.runner.getStdin() == System.in && ConsoleHandle.isConsoleSupported()) {
                ConsoleHandle streamHandle = new ConsoleHandle((GenericNodeRuntime)this.runner);
                return this.createConsoleHandle(cx, (AbstractHandle)streamHandle);
            }
            JavaInputStreamHandle streamHandle = new JavaInputStreamHandle(this.runner.getStdin(), (GenericNodeRuntime)this.runner);
            return this.createStreamHandle(cx, (AbstractHandle)streamHandle);
        }

        public void setArgv(String[] args) {
            Object[] argvArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                argvArgs[i] = args[i];
            }
            this.argv = Context.getCurrentContext().newArray((Scriptable)this, argvArgs);
        }

        private static void abort() throws NodeExitException {
            throw new NodeExitException(NodeExitException.Reason.FATAL);
        }

        private static void reallyExit(Object[] args) throws NodeExitException {
            if (args.length >= 1) {
                int code = (Integer)Context.jsToJava((Object)args[0], Integer.class);
                throw new NodeExitException(NodeExitException.Reason.NORMAL, code);
            }
            throw new NodeExitException(NodeExitException.Reason.NORMAL, 0);
        }

        private void send(Context cx, Object[] args) {
            Object message = ArgUtils.objArg((Object[])args, (int)0, Object.class, (boolean)true);
            if (!this.connected) {
                throw Utils.makeError((Context)cx, (Scriptable)this, (String)"IPC to the parent is disconnected");
            }
            if (this.runner.getParentProcess() == null) {
                throw Utils.makeError((Context)cx, (Scriptable)this, (String)"IPC is not enabled back to the parent");
            }
            TriremeProcess childObj = this.runner.getParentProcess();
            childObj.getRuntime().enqueueIpc(cx, message, childObj);
        }

        private void disconnect(Context cx) {
            if (this.runner.getParentProcess() == null) {
                throw Utils.makeError((Context)cx, (Scriptable)this, (String)"IPC is not enabled back to the parent");
            }
            TriremeProcess childObj = this.runner.getParentProcess();
            this.emit.call(cx, (Scriptable)this.emit, (Scriptable)this, new Object[]{"disconnected"});
            this.connected = false;
            childObj.getRuntime().enqueueIpc(cx, TriremeProcess.IPC_DISCONNECT, childObj);
        }

        public void submitTick(Context cx, Object[] args, Function function, Scriptable thisObj, Object callDomain) {
            Object[] callArgs = new Object[(args == null ? 0 : args.length) + 3];
            callArgs[0] = function;
            callArgs[1] = thisObj;
            callArgs[2] = callDomain;
            if (args != null) {
                System.arraycopy(args, 0, callArgs, 3, args.length);
            }
            this.submitTick.call(cx, (Scriptable)function, (Scriptable)this, callArgs);
        }

        public void processTickTasks(Context cx) {
            this.needTickCallback = false;
            this.tickSpinnerCallback.call(cx, (Scriptable)this.tickSpinnerCallback, (Scriptable)this, ScriptRuntime.emptyArgs);
        }

        public boolean isTickTaskPending() {
            return this.needTickCallback;
        }

        public boolean isImmediateTaskPending() {
            return this.needImmediateCallback;
        }

        public void processImmediateTasks(Context cx) {
            if (log.isTraceEnabled()) {
                log.trace("Calling immediate timer tasks");
            }
            this.immediateCallback.call(cx, (Scriptable)this.immediateCallback, (Scriptable)this, ScriptRuntime.emptyArgs);
            if (log.isTraceEnabled()) {
                log.trace("Immediate tasks done. needImmediateCallback = {}", (Object)this.needImmediateCallback);
            }
        }

        public void emitEvent(String event, Object arg, Context cx, Scriptable scope) {
            if ("disconnect".equals(event)) {
                if (this.connected) {
                    this.connected = false;
                    this.emit.call(cx, scope, (Scriptable)this, new Object[]{event});
                }
            } else {
                this.emit.call(cx, scope, (Scriptable)this, new Object[]{event, arg});
            }
        }

        public Function getHandleFatal() {
            return this.fatalException;
        }

        static {
            props.addMethod("binding", 2, 1);
            props.addMethod("dlopen", 3, 2);
            props.addMethod("abort", 4, 0);
            props.addMethod("chdir", 5, 1);
            props.addMethod("cwd", 6, 0);
            props.addMethod("reallyExit", 7, 1);
            props.addMethod("_kill", 8, 2);
            props.addMethod("send", 9, 1);
            props.addMethod("disconnect", 10, 0);
            props.addMethod("memoryUsage", 11, 0);
            props.addMethod("_pin", 12, 0);
            props.addMethod("_unpin", 13, 0);
            props.addMethod("_needTickCallback", 14, 0);
            props.addMethod("umask", 15, 1);
            props.addMethod("uptime", 16, 0);
            props.addMethod("hrtime", 17, 1);
            props.addProperty("_eval", 1, 0);
            props.addProperty("_print_eval", 2, 0);
            props.addProperty("_forceRepl", 3, 0);
            props.addProperty("_tickInfoBox", 4, 1);
            props.addProperty("connected", 5, 0);
            props.addProperty("_childProcess", 6, 0);
            props.addProperty("_stdoutHandle", 7, 1);
            props.addProperty("_stderrHandle", 8, 1);
            props.addProperty("_stdinHandle", 9, 1);
            props.addProperty("argv", 10, 0);
            props.addProperty("execArgv", 11, 1);
            props.addProperty("execPath", 12, 1);
            props.addProperty("env", 13, 1);
            props.addProperty("version", 14, 1);
            props.addProperty("versions", 15, 1);
            props.addProperty("config", 16, 1);
            props.addProperty("title", 17, 0);
            props.addProperty("arch", 18, 1);
            props.addProperty("pid", 19, 1);
            props.addProperty("_errno", 20, 1);
            props.addProperty("platform", 21, 1);
            props.addProperty("_submitTick", 22, 0);
            props.addProperty("emit", 23, 0);
            props.addProperty("_tickCallback", 24, 0);
            props.addProperty("_tickFromSpinner", 25, 0);
            props.addProperty("_needImmediateCallback", 26, 0);
            props.addProperty("_immediateCallback", 27, 0);
            props.addProperty("_fatalException", 28, 0);
            props.addProperty("features", 29, 1);
            props.addProperty("domain", 30, 0);
            props.addProperty("_exiting", 31, 0);
            props.addProperty("throwDeprecation", 32, 0);
            props.addProperty("traceDeprecation", 33, 0);
        }
    }
}

