/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.blobstore.client.api;

public final class HeadResult {
    private final String hash;
    private final long contentLength;

    public static HeadResult create(String string, long l) {
        return new HeadResult(string, l);
    }

    HeadResult(String string, long l) {
        this.hash = string;
        this.contentLength = l;
    }

    public String hash() {
        return this.hash;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public String toString() {
        return "HeadResult{hash='" + this.hash + '\'' + ", contentLength=" + this.contentLength + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HeadResult headResult = (HeadResult)object;
        if (this.contentLength != headResult.contentLength) {
            return false;
        }
        return this.hash.equals(headResult.hash);
    }

    public int hashCode() {
        int n = this.hash.hashCode();
        n = 31 * n + (int)(this.contentLength ^ this.contentLength >>> 32);
        return n;
    }
}

