/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.blobstore.client.api;

import com.google.common.base.Function;

public final class PutResult {
    public static final Function<String, PutResult> CREATED = new Function<String, PutResult>(){

        public PutResult apply(String string) {
            return PutResult.created(string);
        }
    };
    public static final Function<String, PutResult> UPDATED = new Function<String, PutResult>(){

        public PutResult apply(String string) {
            return PutResult.updated(string);
        }
    };
    private final Status status;
    private final String hash;

    public static PutResult updated(String string) {
        return new PutResult(Status.UPDATED, string);
    }

    public static PutResult created(String string) {
        return new PutResult(Status.CREATED, string);
    }

    PutResult(Status status, String string) {
        this.status = status;
        this.hash = string;
    }

    public String hash() {
        return this.hash;
    }

    public Status status() {
        return this.status;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PutResult putResult = (PutResult)object;
        if (!this.hash.equals(putResult.hash)) {
            return false;
        }
        return this.status == putResult.status;
    }

    public int hashCode() {
        return 31 * this.status.hashCode() + this.hash.hashCode();
    }

    public String toString() {
        return "PutResult{status=" + (Object)((Object)this.status) + ", hash='" + this.hash + '\'' + '}';
    }

    public static enum Status {
        CREATED,
        UPDATED;

    }
}

