/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.QueueMessageBatchVisibility;
import io.awspring.cloud.sqs.listener.Visibility;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public class QueueMessageVisibility
implements Visibility {
    private static final Logger logger = LoggerFactory.getLogger(QueueMessageVisibility.class);
    private final SqsAsyncClient sqsAsyncClient;
    private final String queueUrl;
    private final String receiptHandle;

    public QueueMessageVisibility(SqsAsyncClient amazonSqsAsync, String queueUrl, String receiptHandle) {
        this.sqsAsyncClient = amazonSqsAsync;
        this.queueUrl = queueUrl;
        this.receiptHandle = receiptHandle;
    }

    public BatchVisibility toBatchVisibility(Collection<Message<?>> messages) {
        return new QueueMessageBatchVisibility(this.sqsAsyncClient, this.queueUrl, messages.stream().map(message -> MessageHeaderUtils.getHeader(message, "Sqs_ReceiptHandle", String.class)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> changeToAsync(int seconds) {
        return this.sqsAsyncClient.changeMessageVisibility(req -> req.queueUrl(this.queueUrl).receiptHandle(this.receiptHandle).visibilityTimeout(Integer.valueOf(seconds))).thenRun(() -> logger.trace("Changed the visibility of message {} to {} seconds", (Object)this.receiptHandle, (Object)seconds));
    }
}

