/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.CompletableFutures;
import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.springframework.messaging.Message;

public interface MessageProcessingPipeline<T> {
    default public CompletableFuture<Message<T>> process(Message<T> message, MessageProcessingContext<T> context) {
        return CompletableFutures.failedFuture(new UnsupportedOperationException("Single message handling not implemented by pipeline " + this.getClass().getSimpleName()));
    }

    default public CompletableFuture<Collection<Message<T>>> process(Collection<Message<T>> messages, MessageProcessingContext<T> context) {
        return CompletableFutures.failedFuture(new UnsupportedOperationException("Batch handling not implemented by pipeline " + this.getClass().getSimpleName()));
    }

    default public CompletableFuture<Message<T>> process(CompletableFuture<Message<T>> message, MessageProcessingContext<T> context) {
        return CompletableFutures.failedFuture(new UnsupportedOperationException("CompletableFuture single message handling not implemented by pipeline " + this.getClass().getSimpleName()));
    }

    default public CompletableFuture<Collection<Message<T>>> processMany(CompletableFuture<Collection<Message<T>>> messages, MessageProcessingContext<T> context) {
        return CompletableFutures.failedFuture(new UnsupportedOperationException("CompletableFuture batch handling not implemented by pipeline " + this.getClass().getSimpleName()));
    }
}

