/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.Partition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Provides information on a broker node.
 */
@JsonPropertyOrder({
  BrokerInfo.JSON_PROPERTY_NODE_ID,
  BrokerInfo.JSON_PROPERTY_HOST,
  BrokerInfo.JSON_PROPERTY_PORT,
  BrokerInfo.JSON_PROPERTY_PARTITIONS,
  BrokerInfo.JSON_PROPERTY_VERSION
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
public class BrokerInfo {
  public static final String JSON_PROPERTY_NODE_ID = "nodeId";
  @javax.annotation.Nullable
  private Integer nodeId;

  public static final String JSON_PROPERTY_HOST = "host";
  @javax.annotation.Nullable
  private String host;

  public static final String JSON_PROPERTY_PORT = "port";
  @javax.annotation.Nullable
  private Integer port;

  public static final String JSON_PROPERTY_PARTITIONS = "partitions";
  @javax.annotation.Nullable
  private List<Partition> partitions = new ArrayList<>();

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nullable
  private String version;

  public BrokerInfo() {
  }

  public BrokerInfo nodeId(@javax.annotation.Nullable Integer nodeId) {
    
    this.nodeId = nodeId;
    return this;
  }

  /**
   * The unique (within a cluster) node ID for the broker.
   * @return nodeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNodeId() {
    return nodeId;
  }


  @JsonProperty(JSON_PROPERTY_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNodeId(@javax.annotation.Nullable Integer nodeId) {
    this.nodeId = nodeId;
  }

  public BrokerInfo host(@javax.annotation.Nullable String host) {
    
    this.host = host;
    return this;
  }

  /**
   * The hostname for reaching the broker.
   * @return host
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HOST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHost() {
    return host;
  }


  @JsonProperty(JSON_PROPERTY_HOST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHost(@javax.annotation.Nullable String host) {
    this.host = host;
  }

  public BrokerInfo port(@javax.annotation.Nullable Integer port) {
    
    this.port = port;
    return this;
  }

  /**
   * The port for reaching the broker.
   * @return port
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPort() {
    return port;
  }


  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPort(@javax.annotation.Nullable Integer port) {
    this.port = port;
  }

  public BrokerInfo partitions(@javax.annotation.Nullable List<Partition> partitions) {
    
    this.partitions = partitions;
    return this;
  }

  public BrokerInfo addPartitionsItem(Partition partitionsItem) {
    if (this.partitions == null) {
      this.partitions = new ArrayList<>();
    }
    this.partitions.add(partitionsItem);
    return this;
  }

  /**
   * A list of partitions managed or replicated on this broker.
   * @return partitions
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARTITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Partition> getPartitions() {
    return partitions;
  }


  @JsonProperty(JSON_PROPERTY_PARTITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitions(@javax.annotation.Nullable List<Partition> partitions) {
    this.partitions = partitions;
  }

  public BrokerInfo version(@javax.annotation.Nullable String version) {
    
    this.version = version;
    return this;
  }

  /**
   * The broker version.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@javax.annotation.Nullable String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrokerInfo brokerInfo = (BrokerInfo) o;
    return Objects.equals(this.nodeId, brokerInfo.nodeId) &&
        Objects.equals(this.host, brokerInfo.host) &&
        Objects.equals(this.port, brokerInfo.port) &&
        Objects.equals(this.partitions, brokerInfo.partitions) &&
        Objects.equals(this.version, brokerInfo.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nodeId, host, port, partitions, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BrokerInfo {\n");
    sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    partitions: ").append(toIndentedString(partitions)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `nodeId` to the URL query string
    if (getNodeId() != null) {
      try {
        joiner.add(String.format("%snodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNodeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `host` to the URL query string
    if (getHost() != null) {
      try {
        joiner.add(String.format("%shost%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHost()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `port` to the URL query string
    if (getPort() != null) {
      try {
        joiner.add(String.format("%sport%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPort()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `partitions` to the URL query string
    if (getPartitions() != null) {
      for (int i = 0; i < getPartitions().size(); i++) {
        if (getPartitions().get(i) != null) {
          joiner.add(getPartitions().get(i).toUrlQueryString(String.format("%spartitions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

