/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.ProcessInstanceCreationRuntimeInstruction;
import io.camunda.client.protocol.rest.RuntimeInstructionType;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProcessInstanceCreationTerminateInstruction
 */
@JsonPropertyOrder({
  ProcessInstanceCreationTerminateInstruction.JSON_PROPERTY_AFTER_ELEMENT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
@JsonIgnoreProperties(
  value = "type", // ignore manually set type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type", visible = true)

public class ProcessInstanceCreationTerminateInstruction extends ProcessInstanceCreationRuntimeInstruction {
  public static final String JSON_PROPERTY_AFTER_ELEMENT_ID = "afterElementId";
  @javax.annotation.Nonnull
  private String afterElementId;

  public ProcessInstanceCreationTerminateInstruction() {

  }

  public ProcessInstanceCreationTerminateInstruction afterElementId(@javax.annotation.Nonnull String afterElementId) {
    
    this.afterElementId = afterElementId;
    return this;
  }

  /**
   * The ID of the element that, once completed or terminated, will cause the process to be terminated. 
   * @return afterElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AFTER_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAfterElementId() {
    return afterElementId;
  }


  @JsonProperty(JSON_PROPERTY_AFTER_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAfterElementId(@javax.annotation.Nonnull String afterElementId) {
    this.afterElementId = afterElementId;
  }

  @Override
  public ProcessInstanceCreationTerminateInstruction type(@javax.annotation.Nonnull RuntimeInstructionType type) {
    this.setType(type);
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceCreationTerminateInstruction processInstanceCreationTerminateInstruction = (ProcessInstanceCreationTerminateInstruction) o;
    return Objects.equals(this.afterElementId, processInstanceCreationTerminateInstruction.afterElementId) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(afterElementId, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceCreationTerminateInstruction {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    afterElementId: ").append(toIndentedString(afterElementId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `afterElementId` to the URL query string
    if (getAfterElementId() != null) {
      try {
        joiner.add(String.format("%safterElementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAfterElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

