/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.MigrateProcessInstanceMappingInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * The migration instructions describe how to migrate a process instance from one process definition to another. 
 */
@JsonPropertyOrder({
  ProcessInstanceMigrationBatchOperationPlan.JSON_PROPERTY_MAPPING_INSTRUCTIONS,
  ProcessInstanceMigrationBatchOperationPlan.JSON_PROPERTY_TARGET_PROCESS_DEFINITION_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessInstanceMigrationBatchOperationPlan {
  public static final String JSON_PROPERTY_MAPPING_INSTRUCTIONS = "mappingInstructions";
  @javax.annotation.Nonnull
  private List<MigrateProcessInstanceMappingInstruction> mappingInstructions = new ArrayList<>();

  public static final String JSON_PROPERTY_TARGET_PROCESS_DEFINITION_KEY = "targetProcessDefinitionKey";
  @javax.annotation.Nonnull
  private String targetProcessDefinitionKey;

  public ProcessInstanceMigrationBatchOperationPlan() {
  }

  public ProcessInstanceMigrationBatchOperationPlan mappingInstructions(@javax.annotation.Nonnull List<MigrateProcessInstanceMappingInstruction> mappingInstructions) {
    
    this.mappingInstructions = mappingInstructions;
    return this;
  }

  public ProcessInstanceMigrationBatchOperationPlan addMappingInstructionsItem(MigrateProcessInstanceMappingInstruction mappingInstructionsItem) {
    if (this.mappingInstructions == null) {
      this.mappingInstructions = new ArrayList<>();
    }
    this.mappingInstructions.add(mappingInstructionsItem);
    return this;
  }

  /**
   * Element mappings from the source process instance to the target process instance.
   * @return mappingInstructions
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MAPPING_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<MigrateProcessInstanceMappingInstruction> getMappingInstructions() {
    return mappingInstructions;
  }


  @JsonProperty(JSON_PROPERTY_MAPPING_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMappingInstructions(@javax.annotation.Nonnull List<MigrateProcessInstanceMappingInstruction> mappingInstructions) {
    this.mappingInstructions = mappingInstructions;
  }

  public ProcessInstanceMigrationBatchOperationPlan targetProcessDefinitionKey(@javax.annotation.Nonnull String targetProcessDefinitionKey) {
    
    this.targetProcessDefinitionKey = targetProcessDefinitionKey;
    return this;
  }

  /**
   * The key of process definition to migrate the process instance to.
   * @return targetProcessDefinitionKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TARGET_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetProcessDefinitionKey() {
    return targetProcessDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_TARGET_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTargetProcessDefinitionKey(@javax.annotation.Nonnull String targetProcessDefinitionKey) {
    this.targetProcessDefinitionKey = targetProcessDefinitionKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceMigrationBatchOperationPlan processInstanceMigrationBatchOperationPlan = (ProcessInstanceMigrationBatchOperationPlan) o;
    return Objects.equals(this.mappingInstructions, processInstanceMigrationBatchOperationPlan.mappingInstructions) &&
        Objects.equals(this.targetProcessDefinitionKey, processInstanceMigrationBatchOperationPlan.targetProcessDefinitionKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mappingInstructions, targetProcessDefinitionKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceMigrationBatchOperationPlan {\n");
    sb.append("    mappingInstructions: ").append(toIndentedString(mappingInstructions)).append("\n");
    sb.append("    targetProcessDefinitionKey: ").append(toIndentedString(targetProcessDefinitionKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `mappingInstructions` to the URL query string
    if (getMappingInstructions() != null) {
      for (int i = 0; i < getMappingInstructions().size(); i++) {
        if (getMappingInstructions().get(i) != null) {
          joiner.add(getMappingInstructions().get(i).toUrlQueryString(String.format("%smappingInstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `targetProcessDefinitionKey` to the URL query string
    if (getTargetProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%stargetProcessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTargetProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

