/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CompleteAdHocSubProcessResultStep1;
import io.camunda.client.api.command.CompleteJobCommandStep1;
import io.camunda.client.api.command.CompleteJobResult;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.enums.JobResultType;
import io.camunda.client.api.response.CompleteJobResponse;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.command.CommandWithVariables;
import io.camunda.client.impl.command.CompleteAdHocSubProcessJobResultImpl;
import io.camunda.client.impl.command.CompleteUserTaskJobResultImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CompleteJobResponseImpl;
import io.camunda.client.protocol.rest.JobCompletionRequest;
import io.camunda.client.protocol.rest.JobResult;
import io.camunda.client.protocol.rest.JobResultActivateElement;
import io.camunda.client.protocol.rest.JobResultAdHocSubProcess;
import io.camunda.client.protocol.rest.JobResultCorrections;
import io.camunda.client.protocol.rest.JobResultUserTask;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CompleteJobCommandImpl
extends CommandWithVariables<CompleteJobCommandStep1>
implements CompleteJobCommandStep1,
CompleteJobCommandStep1.CompleteJobCommandJobResultStep {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CompleteJobRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JobCompletionRequest httpRequestObject;
    private boolean useRest;
    private final long jobKey;
    private final JsonMapper jsonMapper;

    public CompleteJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.CompleteJobRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(key);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobCompletionRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = key;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public FinalCommandStep<CompleteJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CompleteJobResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    @Override
    public CompleteJobCommandStep1 withResult(Function<CompleteJobCommandStep1.CompleteJobCommandJobResultStep, CompleteJobResult> function) {
        CompleteJobResult result = function.apply(this);
        if (result instanceof CompleteUserTaskJobResultImpl) {
            this.setJobResult((CompleteUserTaskJobResultImpl)result);
        } else if (result instanceof CompleteAdHocSubProcessResultStep1) {
            this.setJobResult((CompleteAdHocSubProcessJobResultImpl)result);
        } else {
            throw new IllegalArgumentException("Unsupported job result type: " + result.getClass().getName());
        }
        return this;
    }

    @Override
    public CompleteUserTaskJobResultImpl forUserTask() {
        return new CompleteUserTaskJobResultImpl();
    }

    @Override
    public CompleteAdHocSubProcessResultStep1 forAdHocSubProcess() {
        return new CompleteAdHocSubProcessJobResultImpl(this.objectMapper);
    }

    private void setJobResult(CompleteUserTaskJobResultImpl jobResult) {
        if (this.useRest) {
            this.setRestJobResult(jobResult);
        } else {
            this.setGrpcJobResult(jobResult);
        }
    }

    private void setRestJobResult(CompleteUserTaskJobResultImpl jobResult) {
        JobResultUserTask resultRest = new JobResultUserTask();
        JobResultCorrections correctionsRest = new JobResultCorrections();
        correctionsRest.assignee(jobResult.getCorrections().getAssignee()).dueDate(jobResult.getCorrections().getDueDate()).followUpDate(jobResult.getCorrections().getFollowUpDate()).candidateUsers(jobResult.getCorrections().getCandidateUsers()).candidateGroups(jobResult.getCorrections().getCandidateGroups()).priority(jobResult.getCorrections().getPriority());
        resultRest.type(this.getJobResultTypeEnum(jobResult.getType())).denied(jobResult.isDenied()).deniedReason(jobResult.getDeniedReason()).corrections(correctionsRest);
        this.httpRequestObject.setResult(resultRest);
    }

    private void setGrpcJobResult(CompleteUserTaskJobResultImpl jobResult) {
        GatewayOuterClass.JobResult.Builder resultGrpc = GatewayOuterClass.JobResult.newBuilder();
        GatewayOuterClass.JobResultCorrections.Builder correctionsGrpc = GatewayOuterClass.JobResultCorrections.newBuilder();
        if (jobResult.getCorrections().getAssignee() != null) {
            correctionsGrpc.setAssignee(jobResult.getCorrections().getAssignee());
        }
        if (jobResult.getCorrections().getDueDate() != null) {
            correctionsGrpc.setDueDate(jobResult.getCorrections().getDueDate());
        }
        if (jobResult.getCorrections().getFollowUpDate() != null) {
            correctionsGrpc.setFollowUpDate(jobResult.getCorrections().getFollowUpDate());
        }
        if (jobResult.getCorrections().getCandidateUsers() != null) {
            correctionsGrpc.setCandidateUsers(GatewayOuterClass.StringList.newBuilder().addAllValues(jobResult.getCorrections().getCandidateUsers()));
        }
        if (jobResult.getCorrections().getCandidateGroups() != null) {
            correctionsGrpc.setCandidateGroups(GatewayOuterClass.StringList.newBuilder().addAllValues(jobResult.getCorrections().getCandidateGroups()));
        }
        if (jobResult.getCorrections().getPriority() != null) {
            correctionsGrpc.setPriority(jobResult.getCorrections().getPriority().intValue());
        }
        resultGrpc.setType(this.getJobResultTypeEnum(jobResult.getType()).getValue()).setDenied(jobResult.isDenied()).setDeniedReason(jobResult.getDeniedReason() == null ? "" : jobResult.getDeniedReason()).setCorrections(correctionsGrpc);
        this.grpcRequestObjectBuilder.setResult(resultGrpc);
    }

    private JobResult.TypeEnum getJobResultTypeEnum(JobResultType type) {
        switch (type) {
            case USER_TASK: {
                return JobResult.TypeEnum.USER_TASK;
            }
            case AD_HOC_SUB_PROCESS: {
                return JobResult.TypeEnum.AD_HOC_SUB_PROCESS;
            }
        }
        throw new IllegalArgumentException("Unsupported job result type: " + (Object)((Object)type));
    }

    private void setJobResult(CompleteAdHocSubProcessJobResultImpl jobResult) {
        if (this.useRest) {
            this.setRestJobResult(jobResult);
        } else {
            this.setGrpcJobResult(jobResult);
        }
    }

    private void setRestJobResult(CompleteAdHocSubProcessJobResultImpl jobResult) {
        JobResultAdHocSubProcess resultRest = new JobResultAdHocSubProcess();
        List<JobResultActivateElement> activateElements = jobResult.getActivateElements().stream().map(element -> {
            JobResultActivateElement activateElement = new JobResultActivateElement().elementId(element.getElementId());
            if (element.getVariables() != null) {
                activateElement.setVariables(this.jsonMapper.fromJsonAsMap(element.getVariables()));
            }
            return activateElement;
        }).collect(Collectors.toList());
        resultRest.type(this.getJobResultTypeEnum(jobResult.getType())).activateElements(activateElements).isCompletionConditionFulfilled(jobResult.isCompletionConditionFulfilled()).isCancelRemainingInstances(jobResult.isCancelRemainingInstances());
        this.httpRequestObject.setResult(resultRest);
    }

    private void setGrpcJobResult(CompleteAdHocSubProcessJobResultImpl jobResult) {
        GatewayOuterClass.JobResult.Builder resultGrpc = GatewayOuterClass.JobResult.newBuilder();
        resultGrpc.setType(this.getJobResultTypeEnum(jobResult.getType()).getValue()).setIsCompletionConditionFulfilled(jobResult.isCompletionConditionFulfilled()).setIsCancelRemainingInstances(jobResult.isCancelRemainingInstances());
        jobResult.getActivateElements().stream().map(element -> {
            GatewayOuterClass.JobResultActivateElement.Builder activateElement = GatewayOuterClass.JobResultActivateElement.newBuilder().setElementId(element.getElementId());
            if (element.getVariables() != null) {
                activateElement.setVariables(element.getVariables());
            }
            return activateElement.build();
        }).forEach(arg_0 -> ((GatewayOuterClass.JobResult.Builder)resultGrpc).addActivateElements(arg_0));
        this.grpcRequestObjectBuilder.setResult(resultGrpc);
    }

    @Override
    public CompleteJobCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public CompleteJobCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    private CamundaFuture<CompleteJobResponse> sendRestRequest() {
        HttpCamundaFuture<CompleteJobResponse> result = new HttpCamundaFuture<CompleteJobResponse>();
        this.httpClient.post("/jobs/" + this.jobKey + "/completion", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), CompleteJobResponseImpl::new, result);
        return result;
    }

    private CamundaFuture<CompleteJobResponse> sendGrpcRequest() {
        GatewayOuterClass.CompleteJobRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse> future = new RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse>(CompleteJobResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).completeJob(request, streamObserver);
    }

    @Override
    protected CompleteJobCommandStep1 setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.jsonMapper.fromJsonAsMap(variables));
        }
        return this;
    }
}

