/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateUserCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CreateUserResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateUserResponseImpl;
import io.camunda.client.protocol.rest.UserCreateResult;
import io.camunda.client.protocol.rest.UserRequest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CreateUserCommandImpl
implements CreateUserCommandStep1 {
    private final UserRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateUserCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserRequest();
    }

    @Override
    public FinalCommandStep<CreateUserResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateUserResponse> send() {
        ArgumentUtil.ensureNotNull("username", this.request.getUsername());
        ArgumentUtil.ensureNotNull("password", this.request.getPassword());
        HttpCamundaFuture<CreateUserResponse> result = new HttpCamundaFuture<CreateUserResponse>();
        CreateUserResponseImpl response = new CreateUserResponseImpl();
        this.httpClient.post("/users", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UserCreateResult.class, response::setResponse, result);
        return result;
    }

    @Override
    public CreateUserCommandStep1 username(String username) {
        ArgumentUtil.ensureNotNull("username", username);
        this.request.setUsername(username);
        return this;
    }

    @Override
    public CreateUserCommandStep1 email(String email) {
        ArgumentUtil.ensureNotNull("email", email);
        this.request.setEmail(email);
        return this;
    }

    @Override
    public CreateUserCommandStep1 name(String name) {
        ArgumentUtil.ensureNotNull("name", name);
        this.request.setName(name);
        return this;
    }

    @Override
    public CreateUserCommandStep1 password(String password) {
        ArgumentUtil.ensureNotNull("password", password);
        this.request.setPassword(password);
        return this;
    }
}

