/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.fetch.DecisionRequirementsGetRequest;
import io.camunda.client.api.search.response.DecisionRequirements;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.DecisionRequirementsImpl;
import io.camunda.client.protocol.rest.DecisionRequirementsResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionRequirementsGetRequestImpl
implements DecisionRequirementsGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long decisionRequirementsKey;

    public DecisionRequirementsGetRequestImpl(HttpClient httpClient, long decisionRequirementsKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.decisionRequirementsKey = decisionRequirementsKey;
    }

    public DecisionRequirementsGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DecisionRequirements> send() {
        HttpCamundaFuture<DecisionRequirements> result = new HttpCamundaFuture<DecisionRequirements>();
        this.httpClient.get(String.format("/decision-requirements/%d", this.decisionRequirementsKey), this.httpRequestConfig.build(), DecisionRequirementsResult.class, DecisionRequirementsImpl::new, result);
        return result;
    }
}

