/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.impl.http.ApiCallback;
import io.camunda.client.impl.http.ApiEntity;
import io.camunda.client.impl.http.ApiEntityConsumer;
import io.camunda.client.impl.http.ApiResponseConsumer;
import io.camunda.client.impl.http.DocumentDataConsumer;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.JsonResponseAndStatusCodeTransformer;
import io.camunda.client.impl.http.JsonResponseTransformer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final int MAX_RETRY_ATTEMPTS = 2;
    private final CloseableHttpAsyncClient client;
    private final ObjectMapper jsonMapper;
    private final URI address;
    private final RequestConfig defaultRequestConfig;
    private final int maxMessageSize;
    private final TimeValue shutdownTimeout;
    private final CredentialsProvider credentialsProvider;

    public HttpClient(CloseableHttpAsyncClient client, ObjectMapper jsonMapper, URI address, RequestConfig defaultRequestConfig, int maxMessageSize, TimeValue shutdownTimeout, CredentialsProvider credentialsProvider) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.address = address;
        this.defaultRequestConfig = defaultRequestConfig;
        this.maxMessageSize = maxMessageSize;
        this.shutdownTimeout = shutdownTimeout;
        this.credentialsProvider = credentialsProvider;
    }

    public void start() {
        this.client.start();
    }

    @Override
    public void close() throws Exception {
        this.client.close(CloseMode.GRACEFUL);
        try {
            this.client.awaitShutdown(this.shutdownTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Expected to await HTTP client shutdown, but was interrupted; client may not be completely shut down", (Throwable)e);
        }
    }

    public RequestConfig.Builder newRequestConfig() {
        return RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
    }

    public <HttpT, RespT> void get(String path, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.get(path, Collections.emptyMap(), requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void get(String path, Map<String, String> queryParams, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.GET, path, queryParams, null, requestConfig, responseType, transformer, result);
    }

    public <RespT> void get(String path, RequestConfig requestConfig, Predicate<Integer> successPredicate, JsonResponseAndStatusCodeTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.get(path, Collections.emptyMap(), requestConfig, successPredicate, transformer, result);
    }

    public <RespT> void get(String path, Map<String, String> queryParams, RequestConfig requestConfig, Predicate<Integer> successPredicate, JsonResponseAndStatusCodeTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.GET, path, queryParams, null, requestConfig, 2, successPredicate, transformer, result, null);
    }

    public <RespT> void post(String path, String body, RequestConfig requestConfig, JsonResponseTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.post(path, body, requestConfig, Void.class, transformer, result);
    }

    public <HttpT, RespT> void post(String path, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.post(path, Collections.emptyMap(), body, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void post(String path, Map<String, String> queryParams, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.POST, path, queryParams, body, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void postMultipart(String path, MultipartEntityBuilder multipartBuilder, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.postMultipart(path, Collections.emptyMap(), multipartBuilder, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void postMultipart(String path, Map<String, String> queryParams, MultipartEntityBuilder multipartBuilder, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        HttpEntity entity = multipartBuilder.build();
        this.sendRequest(Method.POST, path, queryParams, entity, requestConfig, responseType, transformer, result);
    }

    public <RespT> void put(String path, String body, RequestConfig requestConfig, JsonResponseTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.PUT, path, Collections.emptyMap(), body, requestConfig, Void.class, transformer, result);
    }

    public <HttpT, RespT> void put(String path, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.PUT, path, Collections.emptyMap(), body, requestConfig, responseType, transformer, result);
    }

    public <RespT> void patch(String path, String body, RequestConfig requestConfig, JsonResponseTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.patch(path, body, requestConfig, Void.class, transformer, result);
    }

    public <HttpT, RespT> void patch(String path, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.PATCH, path, Collections.emptyMap(), body, requestConfig, responseType, transformer, result);
    }

    public <RespT> void delete(String path, RequestConfig requestConfig, JsonResponseTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.delete(path, Collections.emptyMap(), requestConfig, transformer, result);
    }

    public <RespT> void delete(String path, Map<String, String> queryParams, RequestConfig requestConfig, JsonResponseTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(Method.DELETE, path, queryParams, null, requestConfig, Void.class, transformer, result);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, Map<String, String> queryParams, Object body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result) {
        this.sendRequest(httpMethod, path, queryParams, body, requestConfig, 2, responseType, transformer, result, null);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, Map<String, String> queryParams, Object body, RequestConfig requestConfig, int maxRetries, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result, ApiCallback<HttpT, RespT> callback) {
        this.sendRequest(httpMethod, path, queryParams, body, requestConfig, maxRetries, responseType, null, (response, statusCode) -> transformer.transform(response), result, callback);
    }

    private <RespT> void sendRequest(Method httpMethod, String path, Map<String, String> queryParams, Object body, RequestConfig requestConfig, int maxRetries, Predicate<Integer> successPredicate, JsonResponseAndStatusCodeTransformer<Void, RespT> transformer, HttpCamundaFuture<RespT> result, ApiCallback<Void, RespT> callback) {
        this.sendRequest(httpMethod, path, queryParams, body, requestConfig, maxRetries, Void.class, successPredicate, transformer, result, callback);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, Map<String, String> queryParams, Object body, RequestConfig requestConfig, int maxRetries, Class<HttpT> responseType, Predicate<Integer> successPredicate, JsonResponseAndStatusCodeTransformer<HttpT, RespT> transformer, HttpCamundaFuture<RespT> result, ApiCallback<HttpT, RespT> callback) {
        AtomicReference apiCallback = new AtomicReference(callback);
        Runnable retryAction = () -> {
            if (result.isCancelled()) {
                return;
            }
            this.sendRequest(httpMethod, path, queryParams, body, requestConfig, maxRetries, responseType, successPredicate, transformer, result, (ApiCallback)apiCallback.get());
        };
        SimpleHttpRequest request = this.buildRequest(httpMethod, queryParams, body, result, this.buildRequestURI(path));
        if (request == null) {
            return;
        }
        request.setConfig(requestConfig);
        AsyncEntityConsumer<ApiEntity<HttpT>> entityConsumer = this.createEntityConsumer(responseType);
        if (apiCallback.get() == null) {
            apiCallback.set(new ApiCallback<HttpT, RespT>(result, transformer, successPredicate, this.credentialsProvider::shouldRetryRequest, retryAction, maxRetries));
        }
        result.transportFuture(this.client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), new ApiResponseConsumer<HttpT>(entityConsumer), (FutureCallback)apiCallback.get()));
    }

    private <HttpT> AsyncEntityConsumer<ApiEntity<HttpT>> createEntityConsumer(Class<HttpT> responseType) {
        if (responseType == InputStream.class) {
            return new DocumentDataConsumer(this.maxMessageSize, this.jsonMapper);
        }
        return new ApiEntityConsumer<HttpT>(this.jsonMapper, responseType, this.maxMessageSize);
    }

    private <RespT> SimpleHttpRequest buildRequest(Method httpMethod, Map<String, String> queryParams, Object body, HttpCamundaFuture<RespT> result, URI target) {
        SimpleRequestBuilder requestBuilder = SimpleRequestBuilder.create((Method)httpMethod).setUri(target);
        this.addQueryParameters(requestBuilder, queryParams);
        if (!this.setRequestBody(requestBuilder, body, result)) {
            return null;
        }
        if (!this.applyCredentials(requestBuilder, result)) {
            return null;
        }
        return requestBuilder.build();
    }

    private void addQueryParameters(SimpleRequestBuilder requestBuilder, Map<String, String> queryParams) {
        if (queryParams != null && !queryParams.isEmpty()) {
            queryParams.forEach((arg_0, arg_1) -> ((SimpleRequestBuilder)requestBuilder).addParameter(arg_0, arg_1));
        }
    }

    private <RespT> boolean setRequestBody(SimpleRequestBuilder requestBuilder, Object body, HttpCamundaFuture<RespT> result) {
        if (body == null) {
            return true;
        }
        if (body instanceof String) {
            requestBuilder.setBody((String)body, ContentType.APPLICATION_JSON);
            return true;
        }
        if (body instanceof HttpEntity) {
            return this.setHttpEntityBody(requestBuilder, (HttpEntity)body, result);
        }
        result.completeExceptionally(new ClientException("Unsupported body type: " + body.getClass().getName()));
        return false;
    }

    private <RespT> boolean setHttpEntityBody(SimpleRequestBuilder requestBuilder, HttpEntity entity, HttpCamundaFuture<RespT> result) {
        byte[] entityBytes;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            entity.writeTo((OutputStream)byteArrayOutputStream);
            entityBytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            result.completeExceptionally(new ClientException("Failed to convert multipart entity to bytes", e));
            return false;
        }
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        requestBuilder.setBody(entityBytes, contentType);
        return true;
    }

    private <RespT> boolean applyCredentials(SimpleRequestBuilder requestBuilder, HttpCamundaFuture<RespT> result) {
        try {
            this.credentialsProvider.applyCredentials((arg_0, arg_1) -> ((SimpleRequestBuilder)requestBuilder).addHeader(arg_0, arg_1));
            return true;
        }
        catch (IOException e) {
            result.completeExceptionally(new ClientException("Failed to apply credentials to request", e));
            return false;
        }
    }

    private URI buildRequestURI(String path) {
        URI target;
        try {
            target = new URIBuilder(this.address).appendPath(path).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return target;
    }
}

