/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.oauth;

import io.camunda.client.impl.BuilderUtils;
import io.camunda.client.impl.oauth.OAuthCredentialsProvider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Objects;

public final class OAuthCredentialsProviderBuilder {
    public static final String INVALID_ARGUMENT_MSG = "Expected valid %s but none was provided.";
    public static final Duration DEFAULT_CONNECT_TIMEOUT;
    public static final Duration DEFAULT_READ_TIMEOUT;
    public static final String DEFAULT_CREDENTIALS_CACHE_PATH;
    private static final String DEFAULT_AUTHZ_SERVER = "https://login.cloud.camunda.io/oauth/token/";
    private String clientId;
    private String clientSecret;
    private String audience;
    private String scope;
    private String resource;
    private String authorizationServerUrl;
    private URL authorizationServer;
    private Path keystorePath;
    private String keystorePassword;
    private String keystoreKeyPassword;
    private Path truststorePath;
    private String truststorePassword;
    private String credentialsCachePath;
    private File credentialsCache;
    private Duration connectTimeout;
    private Duration readTimeout;
    private boolean applyEnvironmentOverrides = true;
    private Path clientAssertionKeystorePath;
    private String clientAssertionKeystorePassword;
    private String clientAssertionKeystoreKeyAlias;
    private String clientAssertionKeystoreKeyPassword;

    public OAuthCredentialsProviderBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    String getClientId() {
        return this.clientId;
    }

    public OAuthCredentialsProviderBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    String getClientSecret() {
        return this.clientSecret;
    }

    public OAuthCredentialsProviderBuilder audience(String audience) {
        this.audience = audience;
        return this;
    }

    String getAudience() {
        return this.audience;
    }

    public OAuthCredentialsProviderBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    String getScope() {
        return this.scope;
    }

    public OAuthCredentialsProviderBuilder resource(String resource) {
        this.resource = resource;
        return this;
    }

    public String getResource() {
        return this.resource;
    }

    public OAuthCredentialsProviderBuilder authorizationServerUrl(String authorizationServerUrl) {
        this.authorizationServerUrl = authorizationServerUrl;
        return this;
    }

    URL getAuthorizationServer() {
        return this.authorizationServer;
    }

    public OAuthCredentialsProviderBuilder keystorePath(Path keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    private OAuthCredentialsProviderBuilder keystorePath(String keystorePath) {
        if (keystorePath != null) {
            return this.keystorePath(Paths.get(keystorePath, new String[0]));
        }
        return this;
    }

    Path getKeystorePath() {
        return this.keystorePath;
    }

    public OAuthCredentialsProviderBuilder keystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    String getKeystorePassword() {
        return this.keystorePassword;
    }

    public OAuthCredentialsProviderBuilder keystoreKeyPassword(String keystoreKeyPassword) {
        this.keystoreKeyPassword = keystoreKeyPassword;
        return this;
    }

    String getKeystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }

    public OAuthCredentialsProviderBuilder truststorePath(Path truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    private OAuthCredentialsProviderBuilder truststorePath(String truststorePath) {
        if (truststorePath != null) {
            return this.truststorePath(Paths.get(truststorePath, new String[0]));
        }
        return this;
    }

    Path getTruststorePath() {
        return this.truststorePath;
    }

    public OAuthCredentialsProviderBuilder truststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    String getTruststorePassword() {
        return this.truststorePassword;
    }

    public OAuthCredentialsProviderBuilder credentialsCachePath(String cachePath) {
        this.credentialsCachePath = cachePath;
        return this;
    }

    File getCredentialsCache() {
        return this.credentialsCache;
    }

    public OAuthCredentialsProviderBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    private OAuthCredentialsProviderBuilder connectTimeout(String connectTimeout) {
        if (connectTimeout != null) {
            return this.connectTimeout(Duration.ofMillis(Long.parseLong(connectTimeout)));
        }
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public OAuthCredentialsProviderBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private OAuthCredentialsProviderBuilder readTimeout(String readTimeout) {
        if (readTimeout != null) {
            return this.readTimeout(Duration.ofMillis(Long.parseLong(readTimeout)));
        }
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public OAuthCredentialsProviderBuilder clientAssertionKeystorePath(String clientAssertionKeystorePath) {
        if (clientAssertionKeystorePath != null) {
            this.clientAssertionKeystorePath = Paths.get(clientAssertionKeystorePath, new String[0]);
        }
        return this;
    }

    public OAuthCredentialsProviderBuilder clientAssertionKeystorePath(Path clientAssertionKeystorePath) {
        if (clientAssertionKeystorePath != null) {
            this.clientAssertionKeystorePath = clientAssertionKeystorePath;
        }
        return this;
    }

    public OAuthCredentialsProviderBuilder clientAssertionKeystorePassword(String clientAssertionKeystorePassword) {
        this.clientAssertionKeystorePassword = clientAssertionKeystorePassword;
        return this;
    }

    public OAuthCredentialsProviderBuilder clientAssertionKeystoreKeyPassword(String clientAssertionKeystoreKeyPassword) {
        this.clientAssertionKeystoreKeyPassword = clientAssertionKeystoreKeyPassword;
        return this;
    }

    public OAuthCredentialsProviderBuilder clientAssertionKeystoreKeyAlias(String clientAssertionKeystoreKeyAlias) {
        this.clientAssertionKeystoreKeyAlias = clientAssertionKeystoreKeyAlias;
        return this;
    }

    public Path getClientAssertionKeystorePath() {
        return this.clientAssertionKeystorePath;
    }

    public String getClientAssertionKeystorePassword() {
        return this.clientAssertionKeystorePassword;
    }

    public String getClientAssertionKeystoreKeyAlias() {
        return this.clientAssertionKeystoreKeyAlias;
    }

    public String getClientAssertionKeystoreKeyPassword() {
        return this.clientAssertionKeystoreKeyPassword;
    }

    public boolean clientAssertionEnabled() {
        return this.clientAssertionKeystorePassword != null && !this.clientAssertionKeystorePassword.isEmpty() && this.clientAssertionKeystorePath != null && this.clientAssertionKeystorePath.toFile().exists();
    }

    public OAuthCredentialsProviderBuilder applyEnvironmentOverrides(boolean applyEnvironmentOverrides) {
        this.applyEnvironmentOverrides = applyEnvironmentOverrides;
        return this;
    }

    public OAuthCredentialsProvider build() {
        if (this.applyEnvironmentOverrides) {
            this.checkEnvironmentOverrides();
            this.applySSLClientCertConfiguration();
        }
        this.applyDefaults();
        this.validate();
        return new OAuthCredentialsProvider(this);
    }

    private void applySSLClientCertConfiguration() {
        BuilderUtils.applyEnvironmentValueIfNotNull(this::clientAssertionKeystorePath, "CAMUNDA_CLIENT_ASSERTION_KEYSTORE_PATH");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::clientAssertionKeystorePassword, "CAMUNDA_CLIENT_ASSERTION_KEYSTORE_PASSWORD");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::clientAssertionKeystoreKeyAlias, "CAMUNDA_CLIENT_ASSERTION_KEYSTORE_KEY_ALIAS");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::clientAssertionKeystoreKeyPassword, "CAMUNDA_CLIENT_ASSERTION_KEYSTORE_KEY_PASSWORD");
    }

    private void checkEnvironmentOverrides() {
        BuilderUtils.applyEnvironmentValueIfNotNull(this::clientId, "CAMUNDA_CLIENT_ID", "ZEEBE_CLIENT_ID");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::clientSecret, "CAMUNDA_CLIENT_SECRET", "ZEEBE_CLIENT_SECRET");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::audience, "CAMUNDA_TOKEN_AUDIENCE", "ZEEBE_TOKEN_AUDIENCE");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::scope, "CAMUNDA_TOKEN_SCOPE", "ZEEBE_TOKEN_SCOPE");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::resource, "CAMUNDA_TOKEN_RESOURCE", "ZEEBE_TOKEN_RESOURCE");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::authorizationServerUrl, "CAMUNDA_AUTHORIZATION_SERVER_URL", "ZEEBE_AUTHORIZATION_SERVER_URL");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::keystorePath, "CAMUNDA_SSL_CLIENT_KEYSTORE_PATH", "ZEEBE_SSL_CLIENT_KEYSTORE_PATH");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::keystorePassword, "CAMUNDA_SSL_CLIENT_KEYSTORE_SECRET", "ZEEBE_SSL_CLIENT_KEYSTORE_SECRET");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::keystoreKeyPassword, "CAMUNDA_SSL_CLIENT_KEYSTORE_KEY_SECRET", "ZEEBE_SSL_CLIENT_KEYSTORE_KEY_SECRET");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::truststorePath, "CAMUNDA_SSL_CLIENT_TRUSTSTORE_PATH", "ZEEBE_SSL_CLIENT_TRUSTSTORE_PATH");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::truststorePassword, "CAMUNDA_SSL_CLIENT_TRUSTSTORE_SECRET", "ZEEBE_SSL_CLIENT_TRUSTSTORE_SECRET");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::credentialsCachePath, "CAMUNDA_CLIENT_CONFIG_PATH", "ZEEBE_CLIENT_CONFIG_PATH");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::readTimeout, "CAMUNDA_AUTH_READ_TIMEOUT", "ZEEBE_AUTH_READ_TIMEOUT");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::connectTimeout, "CAMUNDA_AUTH_CONNECT_TIMEOUT", "ZEEBE_AUTH_CONNECT_TIMEOUT");
    }

    private void applyDefaults() {
        if (this.credentialsCachePath == null) {
            this.credentialsCachePath = DEFAULT_CREDENTIALS_CACHE_PATH;
        }
        if (this.authorizationServerUrl == null) {
            this.authorizationServerUrl = DEFAULT_AUTHZ_SERVER;
        }
        if (this.connectTimeout == null) {
            this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        }
        if (this.readTimeout == null) {
            this.readTimeout = DEFAULT_READ_TIMEOUT;
        }
        if (this.clientAssertionKeystoreKeyPassword == null) {
            this.clientAssertionKeystoreKeyPassword = this.clientAssertionKeystorePassword;
        }
    }

    private void validate() {
        try {
            Objects.requireNonNull(this.clientId, String.format(INVALID_ARGUMENT_MSG, "client id"));
            if (this.clientAssertionEnabled()) {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(Files.newInputStream(Paths.get(this.clientAssertionKeystorePath.toAbsolutePath().toString(), new String[0]), new OpenOption[0]), this.clientAssertionKeystorePassword.toCharArray());
                if (this.clientAssertionKeystoreKeyAlias == null) {
                    this.clientAssertionKeystoreKeyAlias = keyStore.aliases().nextElement();
                }
            } else {
                Objects.requireNonNull(this.clientSecret, String.format(INVALID_ARGUMENT_MSG, "client secret"));
            }
            Objects.requireNonNull(this.audience, String.format(INVALID_ARGUMENT_MSG, "audience"));
            Objects.requireNonNull(this.authorizationServerUrl, String.format(INVALID_ARGUMENT_MSG, "authorization server URL"));
            this.authorizationServer = new URL(this.authorizationServerUrl);
            if (this.keystorePath != null && !this.keystorePath.toFile().exists()) {
                throw new IllegalArgumentException("Keystore path does not exist: " + this.keystorePath);
            }
            if (this.truststorePath != null && !this.truststorePath.toFile().exists()) {
                throw new IllegalArgumentException("Truststore path does not exist: " + this.keystorePath);
            }
            this.credentialsCache = new File(this.credentialsCachePath);
            if (this.credentialsCache.isDirectory()) {
                throw new IllegalArgumentException("Expected specified credentials cache to be a file but found directory instead.");
            }
            this.validateTimeout(this.connectTimeout, "ConnectTimeout");
            this.validateTimeout(this.readTimeout, "ReadTimeout");
        }
        catch (IOException | NullPointerException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void validateTimeout(Duration timeout, String timeoutName) {
        if (timeout.isZero() || timeout.isNegative() || timeout.toMillis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("%s timeout is %s milliseconds, expected timeout to be a positive number of milliseconds smaller than %s.", timeoutName, timeout.toMillis(), Integer.MAX_VALUE));
        }
    }

    static {
        DEFAULT_READ_TIMEOUT = DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
        DEFAULT_CREDENTIALS_CACHE_PATH = Paths.get(System.getProperty("user.home"), ".camunda", "credentials").toAbsolutePath().toString();
    }
}

