/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.response;

import io.camunda.client.api.response.Decision;
import io.camunda.client.api.response.DecisionRequirements;
import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.api.response.Form;
import io.camunda.client.api.response.Process;
import io.camunda.client.api.response.Resource;
import io.camunda.client.impl.Loggers;
import io.camunda.client.impl.response.DecisionImpl;
import io.camunda.client.impl.response.DecisionRequirementsImpl;
import io.camunda.client.impl.response.FormImpl;
import io.camunda.client.impl.response.ProcessImpl;
import io.camunda.client.impl.response.ResourceImpl;
import io.camunda.client.protocol.rest.DeploymentDecisionRequirementsResult;
import io.camunda.client.protocol.rest.DeploymentDecisionResult;
import io.camunda.client.protocol.rest.DeploymentFormResult;
import io.camunda.client.protocol.rest.DeploymentMetadataResult;
import io.camunda.client.protocol.rest.DeploymentProcessResult;
import io.camunda.client.protocol.rest.DeploymentResourceResult;
import io.camunda.client.protocol.rest.DeploymentResult;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;

public final class DeploymentEventImpl
implements DeploymentEvent {
    private static final Logger LOG = Loggers.LOGGER;
    private static final String UNKNOWN_METADATA_WARN_MSG = "Expected metadata in deployment response, but encountered an unknown type of metadata. This might happen when you've updated your Camunda cluster, but not your Camunda client. You may have to update the version of your camunda-client-java dependency to resolve the issue.";
    private final long key;
    private final String tenantId;
    private final List<Process> processes = new ArrayList<Process>();
    private final List<Decision> decisions = new ArrayList<Decision>();
    private final List<DecisionRequirements> decisionRequirements = new ArrayList<DecisionRequirements>();
    private final List<Form> forms = new ArrayList<Form>();
    private final List<Resource> resources = new ArrayList<Resource>();

    public DeploymentEventImpl(GatewayOuterClass.DeployProcessResponse response) {
        this.key = response.getKey();
        this.tenantId = "<default>";
        response.getProcessesList().stream().map(ProcessImpl::new).forEach(this.processes::add);
    }

    public DeploymentEventImpl(GatewayOuterClass.DeployResourceResponse response) {
        this.key = response.getKey();
        this.tenantId = response.getTenantId();
        block6: for (GatewayOuterClass.Deployment deployment : response.getDeploymentsList()) {
            switch (deployment.getMetadataCase()) {
                case PROCESS: {
                    this.processes.add(new ProcessImpl(deployment.getProcess()));
                    continue block6;
                }
                case DECISION: {
                    this.decisions.add(new DecisionImpl(deployment.getDecision()));
                    continue block6;
                }
                case DECISIONREQUIREMENTS: {
                    this.decisionRequirements.add(new DecisionRequirementsImpl(deployment.getDecisionRequirements()));
                    continue block6;
                }
                case FORM: {
                    this.forms.add(new FormImpl(deployment.getForm()));
                    continue block6;
                }
            }
            LOG.warn(UNKNOWN_METADATA_WARN_MSG);
        }
    }

    public DeploymentEventImpl(DeploymentResult response) {
        this.key = Long.parseLong(response.getDeploymentKey());
        this.tenantId = response.getTenantId();
        for (DeploymentMetadataResult deployment : response.getDeployments()) {
            this.addDeployedForm(deployment.getForm());
            this.addDeployedProcess(deployment.getProcessDefinition());
            this.addDeployedDecision(deployment.getDecisionDefinition());
            this.addDeployedDecisionRequirements(deployment.getDecisionRequirements());
            this.addDeployedResource(deployment.getResource());
        }
    }

    private void addDeployedForm(DeploymentFormResult form) {
        Optional.ofNullable(form).ifPresent(f -> this.forms.add(new FormImpl(f.getFormId(), f.getVersion(), Long.parseLong(f.getFormKey()), f.getResourceName(), f.getTenantId())));
    }

    private void addDeployedResource(DeploymentResourceResult resource) {
        Optional.ofNullable(resource).ifPresent(f -> this.resources.add(new ResourceImpl(f.getResourceId(), Long.parseLong(f.getResourceKey()), f.getVersion(), f.getResourceName(), f.getTenantId())));
    }

    private void addDeployedDecisionRequirements(DeploymentDecisionRequirementsResult decisionRequirement) {
        Optional.ofNullable(decisionRequirement).ifPresent(dr -> this.decisionRequirements.add(new DecisionRequirementsImpl(dr.getDecisionRequirementsId(), dr.getDecisionRequirementsName(), dr.getVersion(), Long.parseLong(dr.getDecisionRequirementsKey()), dr.getResourceName(), dr.getTenantId())));
    }

    private void addDeployedDecision(DeploymentDecisionResult decision) {
        Optional.ofNullable(decision).ifPresent(d -> this.decisions.add(new DecisionImpl(d.getDecisionDefinitionId(), d.getName(), d.getVersion(), Long.parseLong(d.getDecisionDefinitionKey()), d.getDecisionRequirementsId(), Long.parseLong(d.getDecisionRequirementsKey()), d.getTenantId())));
    }

    private void addDeployedProcess(DeploymentProcessResult process) {
        Optional.ofNullable(process).ifPresent(p -> this.processes.add(new ProcessImpl(Long.parseLong(p.getProcessDefinitionKey()), p.getProcessDefinitionId(), p.getProcessDefinitionVersion(), p.getResourceName(), p.getTenantId())));
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public List<Process> getProcesses() {
        return this.processes;
    }

    @Override
    public List<Decision> getDecisions() {
        return this.decisions;
    }

    @Override
    public List<DecisionRequirements> getDecisionRequirements() {
        return this.decisionRequirements;
    }

    @Override
    public List<Form> getForm() {
        return this.forms;
    }

    @Override
    public List<Resource> getResource() {
        return this.resources;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return "DeploymentEventImpl{key=" + this.key + ", processes=" + this.processes + ", decisions=" + this.decisions + ", decisionRequirements=" + this.decisionRequirements + ", forms=" + this.forms + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

