/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.response;

import io.camunda.client.api.response.Form;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Objects;

public class FormImpl
implements Form {
    private final String formId;
    private final int version;
    private final long formKey;
    private final String resourceName;
    private final String tenantId;

    public FormImpl(GatewayOuterClass.FormMetadata formMetadata) {
        this(formMetadata.getFormId(), formMetadata.getVersion(), formMetadata.getFormKey(), formMetadata.getResourceName(), formMetadata.getTenantId());
    }

    public FormImpl(String formId, int version, long formKey, String resourceName, String tenantId) {
        this.formId = formId;
        this.version = version;
        this.formKey = formKey;
        this.resourceName = resourceName;
        this.tenantId = tenantId;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getFormKey() {
        return this.formKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(this.formId, this.version, this.formKey, this.resourceName, this.tenantId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormImpl form = (FormImpl)o;
        return this.version == form.version && this.formKey == form.formKey && Objects.equals(this.formId, form.getFormId()) && Objects.equals(this.resourceName, form.resourceName) && Objects.equals(this.tenantId, form.tenantId);
    }

    public String toString() {
        return "FormImpl{formId='" + this.formId + '\'' + ", version=" + this.version + '\'' + ", formKey=" + this.formKey + '\'' + ", resourceName='" + this.resourceName + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

