/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.IncidentsByProcessInstanceSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.IncidentSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.IncidentSearchQueryResult;
import io.camunda.client.protocol.rest.ProcessInstanceIncidentSearchQuery;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class IncidentsByProcessInstanceSearchRequestImpl
implements IncidentsByProcessInstanceSearchRequest {
    private final ProcessInstanceIncidentSearchQuery request;
    private final long processInstanceKey;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public IncidentsByProcessInstanceSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, long processInstanceKey) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.processInstanceKey = processInstanceKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new ProcessInstanceIncidentSearchQuery();
    }

    @Override
    public FinalSearchRequestStep<Incident> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Incident>> send() {
        HttpCamundaFuture<SearchResponse<Incident>> result = new HttpCamundaFuture<SearchResponse<Incident>>();
        this.httpClient.post(String.format("/process-instances/%d/incidents/search", this.processInstanceKey), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), IncidentSearchQueryResult.class, SearchResponseMapper::toIncidentSearchResponse, result);
        return result;
    }

    @Override
    public IncidentsByProcessInstanceSearchRequest sort(IncidentSort value) {
        this.request.setSort(SearchRequestSortMapper.toIncidentSearchQuerySortRequest((List)TypedSearchRequestPropertyProvider.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public IncidentsByProcessInstanceSearchRequest sort(Consumer<IncidentSort> fn) {
        return this.sort(SearchRequestBuilders.incidentSort(fn));
    }

    @Override
    public IncidentsByProcessInstanceSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)TypedSearchRequestPropertyProvider.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public IncidentsByProcessInstanceSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }
}

