/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.MappingRuleFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.MappingRulesByGroupSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.MappingRule;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.MappingRuleSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.MappingRuleSearchQueryRequest;
import io.camunda.client.protocol.rest.MappingRuleSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class MappingRulesByGroupSearchRequestImpl
extends TypedSearchRequestPropertyProvider<MappingRuleSearchQueryRequest>
implements MappingRulesByGroupSearchRequest {
    private final MappingRuleSearchQueryRequest request;
    private final String groupId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public MappingRulesByGroupSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String groupId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.groupId = groupId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new MappingRuleSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<MappingRule> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<MappingRule>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<SearchResponse<MappingRule>> result = new HttpCamundaFuture<SearchResponse<MappingRule>>();
        this.httpClient.post(String.format("/groups/%s/mapping-rules/search", this.groupId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), MappingRuleSearchQueryResult.class, SearchResponseMapper::toMappingRulesResponse, result);
        return result;
    }

    @Override
    public MappingRulesByGroupSearchRequest filter(MappingRuleFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.MappingRuleFilter)MappingRulesByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public MappingRulesByGroupSearchRequest filter(Consumer<MappingRuleFilter> fn) {
        return this.filter(SearchRequestBuilders.mappingRuleFilter(fn));
    }

    @Override
    public MappingRulesByGroupSearchRequest sort(MappingRuleSort value) {
        this.request.setSort(SearchRequestSortMapper.toMappingRuleSearchQuerySortRequest((List)MappingRulesByGroupSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public MappingRulesByGroupSearchRequest sort(Consumer<MappingRuleSort> fn) {
        return this.sort(SearchRequestBuilders.mappingRuleSort(fn));
    }

    @Override
    public MappingRulesByGroupSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)MappingRulesByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public MappingRulesByGroupSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected MappingRuleSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

