/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.GroupUserFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UsersByGroupSearchRequest;
import io.camunda.client.api.search.response.GroupUser;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.GroupUserSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.GroupUserSearchQueryRequest;
import io.camunda.client.protocol.rest.GroupUserSearchResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UsersByGroupSearchRequestImpl
extends TypedSearchRequestPropertyProvider<GroupUserSearchQueryRequest>
implements UsersByGroupSearchRequest {
    private final GroupUserSearchQueryRequest request;
    private final String groupId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public UsersByGroupSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String groupId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.groupId = groupId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new GroupUserSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<GroupUser> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<GroupUser>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<SearchResponse<GroupUser>> result = new HttpCamundaFuture<SearchResponse<GroupUser>>();
        this.httpClient.post(String.format("/groups/%s/users/search", this.groupId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), GroupUserSearchResult.class, SearchResponseMapper::toGroupUsersResponse, result);
        return result;
    }

    @Override
    public UsersByGroupSearchRequest filter(GroupUserFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public UsersByGroupSearchRequest filter(Consumer<GroupUserFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public UsersByGroupSearchRequest sort(GroupUserSort value) {
        this.request.setSort(SearchRequestSortMapper.toGroupUserSearchQuerySortRequest((List)UsersByGroupSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UsersByGroupSearchRequest sort(Consumer<GroupUserSort> fn) {
        return this.sort(SearchRequestBuilders.groupUserSort(fn));
    }

    @Override
    public UsersByGroupSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UsersByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersByGroupSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected GroupUserSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

