/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.response.ProcessInstanceCallHierarchyEntryResponse;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.ProcessInstanceCallHierarchyEntry;
import java.util.Objects;

public class ProcessInstanceCallHierarchyEntryResponseImpl
implements ProcessInstanceCallHierarchyEntryResponse {
    private final Long processInstanceKey;
    private final Long processDefinitionKey;
    private final String processDefinitionName;

    public ProcessInstanceCallHierarchyEntryResponseImpl(ProcessInstanceCallHierarchyEntry entry) {
        this.processInstanceKey = ParseUtil.parseLongOrNull(entry.getProcessInstanceKey());
        this.processDefinitionKey = ParseUtil.parseLongOrNull(entry.getProcessDefinitionKey());
        this.processDefinitionName = entry.getProcessDefinitionName();
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceKey, this.processDefinitionKey, this.processDefinitionName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceCallHierarchyEntryResponseImpl other = (ProcessInstanceCallHierarchyEntryResponseImpl)obj;
        return Objects.equals(this.processInstanceKey, other.processInstanceKey) && Objects.equals(this.processDefinitionKey, other.processDefinitionKey) && Objects.equals(this.processDefinitionName, other.processDefinitionName);
    }

    public String toString() {
        return String.format("ProcessInstanceCallHierarchyEntryImpl{processInstanceKey=%d, processDefinitionKey=%d, processDefinitionName='%s'}", this.processInstanceKey, this.processDefinitionKey, this.processDefinitionName);
    }
}

