/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.ProcessInstanceState;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.ProcessInstanceResult;
import java.time.OffsetDateTime;
import java.util.Set;

public class ProcessInstanceImpl
implements ProcessInstance {
    private final Long processInstanceKey;
    private final String processDefinitionId;
    private final String processDefinitionName;
    private final Integer processDefinitionVersion;
    private final String processDefinitionVersionTag;
    private final Long processDefinitionKey;
    private final Long parentProcessInstanceKey;
    private final Long parentElementInstanceKey;
    private final OffsetDateTime startDate;
    private final OffsetDateTime endDate;
    private final ProcessInstanceState state;
    private final Boolean hasIncident;
    private final String tenantId;
    private final Set<String> tags;

    public ProcessInstanceImpl(ProcessInstanceResult item) {
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processDefinitionName = item.getProcessDefinitionName();
        this.processDefinitionVersion = item.getProcessDefinitionVersion();
        this.processDefinitionVersionTag = item.getProcessDefinitionVersionTag();
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.parentProcessInstanceKey = ParseUtil.parseLongOrNull(item.getParentProcessInstanceKey());
        this.parentElementInstanceKey = ParseUtil.parseLongOrNull(item.getParentElementInstanceKey());
        this.startDate = ParseUtil.parseOffsetDateTimeOrNull(item.getStartDate());
        this.endDate = ParseUtil.parseOffsetDateTimeOrNull(item.getEndDate());
        this.state = EnumUtil.convert(item.getState(), ProcessInstanceState.class);
        this.hasIncident = item.getHasIncident();
        this.tenantId = item.getTenantId();
        this.tags = item.getTags();
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public String getProcessDefinitionVersionTag() {
        return this.processDefinitionVersionTag;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKey;
    }

    @Override
    public Long getParentElementInstanceKey() {
        return this.parentElementInstanceKey;
    }

    @Override
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public ProcessInstanceState getState() {
        return this.state;
    }

    @Override
    public Boolean getHasIncident() {
        return this.hasIncident;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }
}

