/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.util;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ParseUtil.class);

    public static Long parseLongOrNull(String input) {
        return input == null ? null : Long.valueOf(Long.parseLong(input));
    }

    public static long parseLongOrEmpty(String input) {
        return input == null ? -1L : Long.parseLong(input);
    }

    public static String keyToString(Long input) {
        return input == null ? null : String.valueOf(input);
    }

    public static OffsetDateTime parseOffsetDateTimeOrNull(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        try {
            try {
                return OffsetDateTime.parse(dateTime);
            }
            catch (DateTimeParseException e) {
                LOG.debug("Failed parsing '{}' as ISO-8601 date-time, trying to parse as zoned ISO-8601 date-time.", (Object)dateTime);
                return ZonedDateTime.parse(dateTime).toOffsetDateTime();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse date: " + dateTime, e);
        }
    }
}

