/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.bean;

import io.camunda.client.bean.BeanInfo;
import io.camunda.client.bean.MethodInfo;
import io.camunda.client.bean.ParameterInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public interface InfoFactory {
    public static InfoFactory instance() {
        ServiceLoader<InfoFactory> serviceLoader = ServiceLoader.load(InfoFactory.class);
        long count = serviceLoader.stream().count();
        if (count == 0L) {
            throw new IllegalStateException("No Builders found for InfoFactory");
        }
        if (count == 1L) {
            return serviceLoader.iterator().next();
        }
        InfoFactory factory = serviceLoader.iterator().next();
        LoggerFactory.getLogger(InfoFactory.class).warn("Found more than one Builder for InfoFactory, returning instance of type {}", factory.getClass());
        return factory;
    }

    public BeanInfo beanInfo(String var1, Supplier<Object> var2, Class<?> var3);

    public MethodInfo methodInfo(BeanInfo var1, Method var2);

    public ParameterInfo parameterInfo(Parameter var1, String var2, MethodInfo var3);
}

