/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.parameter;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.AnnotationUtil;
import io.camunda.client.annotation.value.DocumentValue;
import io.camunda.client.annotation.value.VariableValue;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.bean.ParameterInfo;
import io.camunda.client.jobhandling.parameter.ActivatedJobParameterResolver;
import io.camunda.client.jobhandling.parameter.CompatActivatedJobParameterResolver;
import io.camunda.client.jobhandling.parameter.CompatJobClientParameterResolver;
import io.camunda.client.jobhandling.parameter.CustomHeadersParameterResolver;
import io.camunda.client.jobhandling.parameter.DocumentParameterResolver;
import io.camunda.client.jobhandling.parameter.JobClientParameterResolver;
import io.camunda.client.jobhandling.parameter.KeyParameterResolver;
import io.camunda.client.jobhandling.parameter.KeyTargetType;
import io.camunda.client.jobhandling.parameter.ParameterResolver;
import io.camunda.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.client.jobhandling.parameter.VariableParameterResolver;
import io.camunda.client.jobhandling.parameter.VariablesAsTypeParameterResolver;
import io.camunda.zeebe.client.api.worker.JobClient;

public class DefaultParameterResolverStrategy
implements ParameterResolverStrategy {
    protected final JsonMapper jsonMapper;
    private final JobClient jobClient;
    private final CamundaClient camundaClient;

    public DefaultParameterResolverStrategy(JsonMapper jsonMapper, JobClient jobClient, CamundaClient camundaClient) {
        this.jsonMapper = jsonMapper;
        this.jobClient = jobClient;
        this.camundaClient = camundaClient;
    }

    public DefaultParameterResolverStrategy(JsonMapper jsonMapper, CamundaClient camundaClient) {
        this(jsonMapper, null, camundaClient);
    }

    @Override
    public ParameterResolver createResolver(ParameterInfo parameterInfo) {
        Class<?> parameterType = parameterInfo.getParameter().getType();
        if (JobClient.class.isAssignableFrom(parameterType)) {
            if (this.jobClient != null) {
                return new CompatJobClientParameterResolver(this.jobClient);
            }
            throw new IllegalStateException("Legacy JobClient is required for parameter " + String.valueOf(parameterInfo) + " of method " + String.valueOf(parameterInfo.getMethodInfo()));
        }
        if (io.camunda.zeebe.client.api.response.ActivatedJob.class.isAssignableFrom(parameterType)) {
            return new CompatActivatedJobParameterResolver();
        }
        if (io.camunda.client.api.worker.JobClient.class.isAssignableFrom(parameterType)) {
            return new JobClientParameterResolver();
        }
        if (ActivatedJob.class.isAssignableFrom(parameterType)) {
            return new ActivatedJobParameterResolver();
        }
        if (AnnotationUtil.isVariable(parameterInfo)) {
            VariableValue variableValue = AnnotationUtil.getVariableValue(parameterInfo).get();
            String variableName = variableValue.getName();
            boolean optional = variableValue.isOptional();
            return new VariableParameterResolver(variableName, parameterType, this.jsonMapper, optional);
        }
        if (AnnotationUtil.isVariablesAsType(parameterInfo)) {
            return new VariablesAsTypeParameterResolver(parameterType);
        }
        if (AnnotationUtil.isCustomHeaders(parameterInfo)) {
            return new CustomHeadersParameterResolver();
        }
        if (AnnotationUtil.isDocument(parameterInfo)) {
            DocumentValue documentValue = AnnotationUtil.getDocumentValue(parameterInfo).get();
            String variableName = documentValue.getName();
            boolean optional = documentValue.isOptional();
            DocumentValue.ParameterType documentParameterType = documentValue.getParameterType();
            return new DocumentParameterResolver(variableName, optional, documentParameterType, this.camundaClient);
        }
        if (AnnotationUtil.isKey(parameterInfo)) {
            return new KeyParameterResolver(KeyTargetType.from(parameterType), AnnotationUtil.getKeyResolver(parameterInfo).get());
        }
        throw new IllegalStateException("Could not create parameter resolver for parameter " + String.valueOf(parameterInfo));
    }
}

