/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.parameter;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.jobhandling.parameter.KeyTargetType;
import io.camunda.client.jobhandling.parameter.ParameterResolver;
import java.util.function.Function;

public class KeyParameterResolver
implements ParameterResolver {
    private final KeyTargetType keyTargetType;
    private final Function<ActivatedJob, Long> keyResolver;

    public KeyParameterResolver(KeyTargetType keyTargetType, Function<ActivatedJob, Long> keyResolver) {
        this.keyTargetType = keyTargetType;
        this.keyResolver = keyResolver;
    }

    public KeyTargetType getKeyTargetType() {
        return this.keyTargetType;
    }

    @Override
    public final Object resolve(JobClient jobClient, ActivatedJob job) {
        Long key = this.keyResolver.apply(job);
        return switch (this.keyTargetType) {
            default -> throw new IncompatibleClassChangeError();
            case KeyTargetType.LONG -> key;
            case KeyTargetType.STRING -> String.valueOf(key);
        };
    }
}

