/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.parameter;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.response.DocumentLinkResponse;
import io.camunda.client.api.response.DocumentReferenceResponse;
import io.camunda.client.jobhandling.DocumentContext;
import java.io.InputStream;
import java.util.List;

public class ParameterDocumentContext
implements DocumentContext {
    private final List<DocumentReferenceResponse> documentReferences;
    private final CamundaClient camundaClient;
    private final boolean optional;

    public ParameterDocumentContext(List<DocumentReferenceResponse> documentReferences, CamundaClient camundaClient, boolean optional) {
        this.documentReferences = documentReferences;
        this.camundaClient = camundaClient;
        this.optional = optional;
    }

    @Override
    public List<DocumentContext.DocumentEntry> getDocuments() {
        return this.documentReferences.stream().map(r -> new ParameterDocumentEntry((DocumentReferenceResponse)r, this.camundaClient, this.optional)).map(DocumentContext.DocumentEntry.class::cast).toList();
    }

    public static class ParameterDocumentEntry
    implements DocumentContext.DocumentEntry {
        private final boolean optional;
        private final DocumentReferenceResponse documentReference;
        private final CamundaClient camundaClient;

        public ParameterDocumentEntry(DocumentReferenceResponse documentReference, CamundaClient camundaClient, boolean optional) {
            this.optional = optional;
            this.documentReference = documentReference;
            this.camundaClient = camundaClient;
        }

        @Override
        public DocumentReferenceResponse getDocumentReference() {
            return this.documentReference;
        }

        @Override
        public InputStream getDocumentInputStream() {
            InputStream in;
            block3: {
                in = null;
                try {
                    in = (InputStream)this.camundaClient.newDocumentContentGetRequest(this.documentReference).execute();
                }
                catch (Exception e) {
                    if (this.optional) break block3;
                    throw new ClientException("Could not get document with id " + this.documentReference.getDocumentId(), (Throwable)e);
                }
            }
            if (!this.optional && in == null) {
                throw new ClientException("Document input stream is null for document with id " + this.documentReference.getDocumentId());
            }
            return in;
        }

        @Override
        public DocumentLinkResponse getDocumentLink() {
            return (DocumentLinkResponse)this.camundaClient.newCreateDocumentLinkCommand(this.documentReference).execute();
        }
    }
}

