/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.bean;

import io.camunda.client.bean.BeanInfo;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public final class SpringBeanInfo
implements BeanInfo {
    private final Supplier<Object> beanSupplier;
    private final String beanName;
    private final Class<?> targetClass;

    public SpringBeanInfo(Supplier<Object> beanSupplier, String beanName, Class<?> targetClass) {
        this.beanSupplier = beanSupplier;
        this.beanName = beanName;
        this.targetClass = targetClass == null ? AopUtils.getTargetClass((Object)beanSupplier.get()) : targetClass;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public boolean hasMethodAnnotation(Class<? extends Annotation> type) {
        return Stream.of(ReflectionUtils.getAllDeclaredMethods(this.getTargetClass())).anyMatch(m -> m.isAnnotationPresent(type));
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.getTargetClass(), type));
    }

    @Override
    public Supplier<Object> getBeanSupplier() {
        return this.beanSupplier;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

