/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.configuration;

import io.camunda.client.CamundaClient;
import io.camunda.client.annotation.customizer.JobWorkerValueCustomizer;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.worker.BackoffSupplier;
import io.camunda.client.jobhandling.CamundaClientExecutorService;
import io.camunda.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.client.jobhandling.DefaultJobExceptionHandlingStrategy;
import io.camunda.client.jobhandling.JobExceptionHandlingStrategy;
import io.camunda.client.jobhandling.JobWorkerManager;
import io.camunda.client.jobhandling.parameter.DefaultParameterResolverStrategy;
import io.camunda.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.client.jobhandling.result.DefaultDocumentResultProcessorFailureHandlingStrategy;
import io.camunda.client.jobhandling.result.DefaultResultProcessorStrategy;
import io.camunda.client.jobhandling.result.DocumentResultProcessorFailureHandlingStrategy;
import io.camunda.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.client.metrics.MetricsRecorder;
import io.camunda.client.spring.configuration.AnnotationProcessorConfiguration;
import io.camunda.client.spring.configuration.CamundaBeanPostProcessorConfiguration;
import io.camunda.client.spring.configuration.JsonMapperConfiguration;
import io.camunda.client.spring.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.client.spring.properties.CamundaClientProperties;
import io.camunda.client.spring.properties.PropertyBasedJobWorkerValueCustomizer;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnCamundaClientEnabled
@Import(value={AnnotationProcessorConfiguration.class, JsonMapperConfiguration.class, CamundaBeanPostProcessorConfiguration.class})
@EnableConfigurationProperties(value={CamundaClientProperties.class})
public class CamundaClientAllAutoConfiguration {
    private final CamundaClientProperties camundaClientProperties;

    public CamundaClientAllAutoConfiguration(CamundaClientProperties camundaClientProperties) {
        this.camundaClientProperties = camundaClientProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public CamundaClientExecutorService camundaClientExecutorService() {
        return CamundaClientExecutorService.createDefault(this.camundaClientProperties.getExecutionThreads());
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandExceptionHandlingStrategy commandExceptionHandlingStrategy(CamundaClientExecutorService scheduledExecutorService) {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), scheduledExecutorService.get());
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterResolverStrategy parameterResolverStrategy(JsonMapper jsonMapper, @Autowired(required=false) ZeebeClient zeebeClient, CamundaClient camundaClient) {
        return new DefaultParameterResolverStrategy(jsonMapper, (JobClient)zeebeClient, camundaClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentResultProcessorFailureHandlingStrategy documentResultProcessorFailureHandlingStrategy() {
        return new DefaultDocumentResultProcessorFailureHandlingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResultProcessorStrategy resultProcessorStrategy(CamundaClient camundaClient, DocumentResultProcessorFailureHandlingStrategy documentResultProcessorFailureHandlingStrategy) {
        return new DefaultResultProcessorStrategy(camundaClient, documentResultProcessorFailureHandlingStrategy);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobExceptionHandlingStrategy jobExceptionHandlingStrategy(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder) {
        return new DefaultJobExceptionHandlingStrategy(commandExceptionHandlingStrategy, metricsRecorder);
    }

    @Bean
    public JobWorkerManager jobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy, BackoffSupplier backoffSupplier, JobExceptionHandlingStrategy jobExceptionHandlingStrategy) {
        return new JobWorkerManager(commandExceptionHandlingStrategy, metricsRecorder, parameterResolverStrategy, resultProcessorStrategy, backoffSupplier, jobExceptionHandlingStrategy);
    }

    @Bean
    @ConditionalOnMissingBean
    public BackoffSupplier backoffSupplier() {
        return BackoffSupplier.newBackoffBuilder().build();
    }

    @Bean(value={"propertyBasedJobWorkerValueCustomizer"})
    @ConditionalOnMissingBean(name={"propertyBasedJobWorkerValueCustomizer"})
    public JobWorkerValueCustomizer propertyBasedJobWorkerValueCustomizer() {
        return new PropertyBasedJobWorkerValueCustomizer(this.camundaClientProperties);
    }
}

