/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.configuration;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.jobhandling.CamundaClientExecutorService;
import io.camunda.client.spring.properties.CamundaClientProperties;
import io.grpc.ClientInterceptor;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCamundaClientConfiguration
implements CamundaClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SpringCamundaClientConfiguration.class);
    private final CamundaClientProperties camundaClientProperties;
    private final JsonMapper jsonMapper;
    private final List<ClientInterceptor> interceptors;
    private final List<AsyncExecChainHandler> chainHandlers;
    private final CamundaClientExecutorService zeebeClientExecutorService;
    private final CredentialsProvider credentialsProvider;

    public SpringCamundaClientConfiguration(CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, List<AsyncExecChainHandler> chainHandlers, CamundaClientExecutorService zeebeClientExecutorService, CredentialsProvider credentialsProvider) {
        this.camundaClientProperties = camundaClientProperties;
        this.jsonMapper = jsonMapper;
        this.interceptors = interceptors;
        this.chainHandlers = chainHandlers;
        this.zeebeClientExecutorService = zeebeClientExecutorService;
        this.credentialsProvider = credentialsProvider;
    }

    public URI getRestAddress() {
        return this.camundaClientProperties.getRestAddress();
    }

    public URI getGrpcAddress() {
        return this.camundaClientProperties.getGrpcAddress();
    }

    public String getDefaultTenantId() {
        return this.camundaClientProperties.getTenantId();
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        return this.camundaClientProperties.getWorker().getDefaults().getTenantIds();
    }

    public int getNumJobWorkerExecutionThreads() {
        return this.camundaClientProperties.getExecutionThreads();
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return this.camundaClientProperties.getWorker().getDefaults().getMaxJobsActive();
    }

    public String getDefaultJobWorkerName() {
        return this.camundaClientProperties.getWorker().getDefaults().getName();
    }

    public Duration getDefaultJobTimeout() {
        return this.camundaClientProperties.getWorker().getDefaults().getTimeout();
    }

    public Duration getDefaultJobPollInterval() {
        return this.camundaClientProperties.getWorker().getDefaults().getPollInterval();
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.camundaClientProperties.getMessageTimeToLive();
    }

    public Duration getDefaultRequestTimeout() {
        return this.camundaClientProperties.getRequestTimeout();
    }

    public Duration getDefaultRequestTimeoutOffset() {
        return this.camundaClientProperties.getRequestTimeoutOffset();
    }

    public String getCaCertificatePath() {
        return this.camundaClientProperties.getCaCertificatePath();
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public Duration getKeepAlive() {
        return this.camundaClientProperties.getKeepAlive();
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<AsyncExecChainHandler> getChainHandlers() {
        return this.chainHandlers;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return this.camundaClientProperties.getOverrideAuthority();
    }

    public int getMaxMessageSize() {
        return Math.toIntExact(this.camundaClientProperties.getMaxMessageSize().toBytes());
    }

    public int getMaxMetadataSize() {
        return Math.toIntExact(this.camundaClientProperties.getMaxMetadataSize().toBytes());
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return this.zeebeClientExecutorService.isOwnedByCamundaClient();
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.camundaClientProperties.getWorker().getDefaults().getStreamEnabled();
    }

    public boolean useDefaultRetryPolicy() {
        return false;
    }

    public boolean preferRestOverGrpc() {
        return this.camundaClientProperties.getPreferRestOverGrpc();
    }

    public int getMaxHttpConnections() {
        return this.camundaClientProperties.getMaxHttpConnections();
    }

    private String composeGatewayAddress() {
        int defaultPort;
        URI gatewayUrl = this.getGrpcAddress();
        int port = gatewayUrl.getPort();
        String host = gatewayUrl.getHost();
        if (port != -1) {
            return this.composeAddressWithPort(host, port, "Gateway port is set");
        }
        try {
            defaultPort = gatewayUrl.toURL().getDefaultPort();
        }
        catch (MalformedURLException e) {
            LOG.warn("Invalid gateway url: {}", (Object)gatewayUrl);
            defaultPort = -1;
        }
        if (defaultPort != -1) {
            return this.composeAddressWithPort(host, defaultPort, "Gateway port has default");
        }
        LOG.debug("Gateway cannot be determined, address will be '{}'", (Object)host);
        return host;
    }

    private String composeAddressWithPort(String host, int port, String debugMessage) {
        String gatewayAddress = host + ":" + port;
        LOG.debug("{}, address will be '{}'", (Object)debugMessage, (Object)gatewayAddress);
        return gatewayAddress;
    }

    private boolean composePlaintext() {
        String protocol;
        return switch (protocol = this.getGrpcAddress().getScheme()) {
            case "http", "grpc" -> true;
            case "https", "grpcs" -> false;
            default -> throw new IllegalStateException(String.format("Unrecognized zeebe protocol '%s'", protocol));
        };
    }

    public String toString() {
        return "CamundaClientConfigurationImpl{camundaClientProperties=" + String.valueOf(this.camundaClientProperties) + ", jsonMapper=" + String.valueOf(this.jsonMapper) + ", interceptors=" + String.valueOf(this.interceptors) + ", chainHandlers=" + String.valueOf(this.chainHandlers) + ", zeebeClientExecutorService=" + String.valueOf(this.zeebeClientExecutorService) + ", credentialsProvider=" + String.valueOf(this.credentialsProvider == null ? "null" : this.credentialsProvider.getClass()) + "}";
    }
}

