/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskListeners;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeUserTask;
import java.util.Collection;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class TaskListenersValidator
implements ModelElementValidator<ZeebeTaskListeners> {
    public Class<ZeebeTaskListeners> getElementType() {
        return ZeebeTaskListeners.class;
    }

    public void validate(ZeebeTaskListeners element, ValidationResultCollector validationResultCollector) {
        Collection<ZeebeTaskListener> taskListeners = element.getTaskListeners();
        if (taskListeners == null || taskListeners.isEmpty()) {
            return;
        }
        if (TaskListenersValidator.taskListenersBelongToCamundaUserTask(element)) {
            return;
        }
        String errorMessage = "Task listeners are only allowed on Camunda user tasks.";
        validationResultCollector.addError(0, "Task listeners are only allowed on Camunda user tasks.");
    }

    private static boolean taskListenersBelongToCamundaUserTask(ZeebeTaskListeners element) {
        Collection extentionElements = element.getParentElement().getParentElement().getChildElementsByType(ExtensionElements.class);
        for (ExtensionElements extensionElements : extentionElements) {
            for (ModelElementInstance extensionElementElement : extensionElements.getElements()) {
                if (!(extensionElementElement instanceof ZeebeUserTask)) continue;
                return true;
            }
        }
        return false;
    }
}

