package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMessageRecordValue.builder()}.
 */
@Generated(from = "MessageRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableMessageRecordValue.Builder.class)
public final class ImmutableMessageRecordValue
    implements MessageRecordValue {
  private final Map<String, Object> variables;
  private final String tenantId;
  private final String name;
  private final String correlationKey;
  private final String messageId;
  private final long timeToLive;
  private final long deadline;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableMessageRecordValue(
      Map<String, Object> variables,
      String tenantId,
      String name,
      String correlationKey,
      String messageId,
      long timeToLive,
      long deadline) {
    this.variables = variables;
    this.tenantId = tenantId;
    this.name = name;
    this.correlationKey = correlationKey;
    this.messageId = messageId;
    this.timeToLive = timeToLive;
    this.deadline = deadline;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the name of the message
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return the correlation key of the message
   */
  @Override
  public String getCorrelationKey() {
    return correlationKey;
  }

  /**
   * The ID of a message is an optional field which is used to make messages unique and prevent
   * publishing the same message twice during its lifetime.
   * @return the id of the message
   */
  @Override
  public String getMessageId() {
    return messageId;
  }

  /**
   * @return the time to live of the message
   */
  @Override
  public long getTimeToLive() {
    return timeToLive;
  }

  /**
   * @return the unix timestamp in milliseconds until when the message can be correlated. If the
   *     deadline is exceeded then the message expires and will be removed. If this property is not
   *     set, it returns -1 instead.
   */
  @Override
  public long getDeadline() {
    return deadline;
  }

  /**
   * Copy the current immutable object by replacing the {@link MessageRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableMessageRecordValue(
        newValue,
        this.tenantId,
        this.name,
        this.correlationKey,
        this.messageId,
        this.timeToLive,
        this.deadline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableMessageRecordValue(
        this.variables,
        value,
        this.name,
        this.correlationKey,
        this.messageId,
        this.timeToLive,
        this.deadline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageRecordValue#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageRecordValue withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableMessageRecordValue(
        this.variables,
        this.tenantId,
        value,
        this.correlationKey,
        this.messageId,
        this.timeToLive,
        this.deadline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageRecordValue#getCorrelationKey() correlationKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for correlationKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageRecordValue withCorrelationKey(String value) {
    if (Objects.equals(this.correlationKey, value)) return this;
    return new ImmutableMessageRecordValue(this.variables, this.tenantId, this.name, value, this.messageId, this.timeToLive, this.deadline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageRecordValue#getMessageId() messageId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageRecordValue withMessageId(String value) {
    if (Objects.equals(this.messageId, value)) return this;
    return new ImmutableMessageRecordValue(
        this.variables,
        this.tenantId,
        this.name,
        this.correlationKey,
        value,
        this.timeToLive,
        this.deadline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageRecordValue#getTimeToLive() timeToLive} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeToLive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageRecordValue withTimeToLive(long value) {
    if (this.timeToLive == value) return this;
    return new ImmutableMessageRecordValue(
        this.variables,
        this.tenantId,
        this.name,
        this.correlationKey,
        this.messageId,
        value,
        this.deadline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageRecordValue#getDeadline() deadline} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deadline
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageRecordValue withDeadline(long value) {
    if (this.deadline == value) return this;
    return new ImmutableMessageRecordValue(
        this.variables,
        this.tenantId,
        this.name,
        this.correlationKey,
        this.messageId,
        this.timeToLive,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessageRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessageRecordValue
        && equalTo(0, (ImmutableMessageRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMessageRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(name, another.name)
        && Objects.equals(correlationKey, another.correlationKey)
        && Objects.equals(messageId, another.messageId)
        && timeToLive == another.timeToLive
        && deadline == another.deadline;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code tenantId}, {@code name}, {@code correlationKey}, {@code messageId}, {@code timeToLive}, {@code deadline}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(correlationKey);
    h += (h << 5) + Objects.hashCode(messageId);
    h += (h << 5) + Long.hashCode(timeToLive);
    h += (h << 5) + Long.hashCode(deadline);
    return h;
  }

  /**
   * Prints the immutable value {@code MessageRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageRecordValue{"
        + "variables=" + variables
        + ", tenantId=" + tenantId
        + ", name=" + name
        + ", correlationKey=" + correlationKey
        + ", messageId=" + messageId
        + ", timeToLive=" + timeToLive
        + ", deadline=" + deadline
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MessageRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageRecordValue instance
   */
  public static ImmutableMessageRecordValue copyOf(MessageRecordValue instance) {
    if (instance instanceof ImmutableMessageRecordValue) {
      return (ImmutableMessageRecordValue) instance;
    }
    return ImmutableMessageRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMessageRecordValue ImmutableMessageRecordValue}.
   * <pre>
   * ImmutableMessageRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link MessageRecordValue#getVariables() variables} mappings
   *    .withTenantId(String | null) // nullable {@link MessageRecordValue#getTenantId() tenantId}
   *    .withName(String | null) // nullable {@link MessageRecordValue#getName() name}
   *    .withCorrelationKey(String | null) // nullable {@link MessageRecordValue#getCorrelationKey() correlationKey}
   *    .withMessageId(String | null) // nullable {@link MessageRecordValue#getMessageId() messageId}
   *    .withTimeToLive(long) // optional {@link MessageRecordValue#getTimeToLive() timeToLive}
   *    .withDeadline(long) // optional {@link MessageRecordValue#getDeadline() deadline}
   *    .build();
   * </pre>
   * @return A new ImmutableMessageRecordValue builder
   */
  public static ImmutableMessageRecordValue.Builder builder() {
    return new ImmutableMessageRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMessageRecordValue ImmutableMessageRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String tenantId;
    private String name;
    private String correlationKey;
    private String messageId;
    private long timeToLive;
    private long deadline;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.MessageRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof MessageRecordValue) {
        MessageRecordValue instance = (MessageRecordValue) object;
        this.withTimeToLive(instance.getTimeToLive());
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          withName(nameValue);
        }
        String messageIdValue = instance.getMessageId();
        if (messageIdValue != null) {
          withMessageId(messageIdValue);
        }
        String correlationKeyValue = instance.getCorrelationKey();
        if (correlationKeyValue != null) {
          withCorrelationKey(correlationKeyValue);
        }
        this.withDeadline(instance.getDeadline());
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Put one entry to the {@link MessageRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MessageRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MessageRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MessageRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MessageRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageRecordValue#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withName(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageRecordValue#getCorrelationKey() correlationKey} attribute.
     * @param correlationKey The value for correlationKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCorrelationKey(String correlationKey) {
      this.correlationKey = correlationKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageRecordValue#getMessageId() messageId} attribute.
     * @param messageId The value for messageId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageId(String messageId) {
      this.messageId = messageId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageRecordValue#getTimeToLive() timeToLive} attribute.
     * @param timeToLive The value for timeToLive 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTimeToLive(long timeToLive) {
      this.timeToLive = timeToLive;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageRecordValue#getDeadline() deadline} attribute.
     * @param deadline The value for deadline 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDeadline(long deadline) {
      this.deadline = deadline;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.tenantId = null;
      this.name = null;
      this.correlationKey = null;
      this.messageId = null;
      this.timeToLive = 0;
      this.deadline = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessageRecordValue ImmutableMessageRecordValue}.
     * @return An immutable instance of MessageRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessageRecordValue build() {
      return new ImmutableMessageRecordValue(
          createUnmodifiableMap(false, false, variables),
          tenantId,
          name,
          correlationKey,
          messageId,
          timeToLive,
          deadline);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
