package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceMigrationMappingInstructionValue.builder()}.
 */
@Generated(from = "ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceMigrationMappingInstructionValue.Builder.class)
public final class ImmutableProcessInstanceMigrationMappingInstructionValue
    implements ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue {
  private final String sourceElementId;
  private final String targetElementId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceMigrationMappingInstructionValue(String sourceElementId, String targetElementId) {
    this.sourceElementId = sourceElementId;
    this.targetElementId = targetElementId;
  }

  /**
   * @return the source element id, or an empty string
   */
  @Override
  public String getSourceElementId() {
    return sourceElementId;
  }

  /**
   * @return the target element id, or an empty string
   */
  @Override
  public String getTargetElementId() {
    return targetElementId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue#getSourceElementId() sourceElementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceElementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceMigrationMappingInstructionValue withSourceElementId(String value) {
    if (Objects.equals(this.sourceElementId, value)) return this;
    return new ImmutableProcessInstanceMigrationMappingInstructionValue(value, this.targetElementId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue#getTargetElementId() targetElementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetElementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceMigrationMappingInstructionValue withTargetElementId(String value) {
    if (Objects.equals(this.targetElementId, value)) return this;
    return new ImmutableProcessInstanceMigrationMappingInstructionValue(this.sourceElementId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceMigrationMappingInstructionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceMigrationMappingInstructionValue
        && equalTo(0, (ImmutableProcessInstanceMigrationMappingInstructionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceMigrationMappingInstructionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(sourceElementId, another.sourceElementId)
        && Objects.equals(targetElementId, another.targetElementId);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code sourceElementId}, {@code targetElementId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(sourceElementId);
    h += (h << 5) + Objects.hashCode(targetElementId);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceMigrationMappingInstructionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceMigrationMappingInstructionValue{"
        + "sourceElementId=" + sourceElementId
        + ", targetElementId=" + targetElementId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceMigrationMappingInstructionValue instance
   */
  public static ImmutableProcessInstanceMigrationMappingInstructionValue copyOf(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue instance) {
    if (instance instanceof ImmutableProcessInstanceMigrationMappingInstructionValue) {
      return (ImmutableProcessInstanceMigrationMappingInstructionValue) instance;
    }
    return ImmutableProcessInstanceMigrationMappingInstructionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceMigrationMappingInstructionValue ImmutableProcessInstanceMigrationMappingInstructionValue}.
   * <pre>
   * ImmutableProcessInstanceMigrationMappingInstructionValue.builder()
   *    .withSourceElementId(String | null) // nullable {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue#getSourceElementId() sourceElementId}
   *    .withTargetElementId(String | null) // nullable {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue#getTargetElementId() targetElementId}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceMigrationMappingInstructionValue builder
   */
  public static ImmutableProcessInstanceMigrationMappingInstructionValue.Builder builder() {
    return new ImmutableProcessInstanceMigrationMappingInstructionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceMigrationMappingInstructionValue ImmutableProcessInstanceMigrationMappingInstructionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String sourceElementId;
    private String targetElementId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessInstanceMigrationMappingInstructionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue instance) {
      Objects.requireNonNull(instance, "instance");
      String sourceElementIdValue = instance.getSourceElementId();
      if (sourceElementIdValue != null) {
        withSourceElementId(sourceElementIdValue);
      }
      String targetElementIdValue = instance.getTargetElementId();
      if (targetElementIdValue != null) {
        withTargetElementId(targetElementIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue#getSourceElementId() sourceElementId} attribute.
     * @param sourceElementId The value for sourceElementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withSourceElementId(String sourceElementId) {
      this.sourceElementId = sourceElementId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue#getTargetElementId() targetElementId} attribute.
     * @param targetElementId The value for targetElementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTargetElementId(String targetElementId) {
      this.targetElementId = targetElementId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.sourceElementId = null;
      this.targetElementId = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceMigrationMappingInstructionValue ImmutableProcessInstanceMigrationMappingInstructionValue}.
     * @return An immutable instance of ProcessInstanceMigrationMappingInstructionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceMigrationMappingInstructionValue build() {
      return new ImmutableProcessInstanceMigrationMappingInstructionValue(sourceElementId, targetElementId);
    }



  }



}
