/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.table;

import cucumber.api.DataTable;
import cucumber.deps.com.thoughtworks.xstream.converters.ConversionException;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.Utils;
import cucumber.runtime.table.CamelCaseStringConverter;
import cucumber.runtime.xstream.CellWriter;
import cucumber.runtime.xstream.ComplexTypeWriter;
import cucumber.runtime.xstream.ListOfComplexTypeReader;
import cucumber.runtime.xstream.ListOfSingleValueWriter;
import cucumber.runtime.xstream.LocalizedXStreams;
import cucumber.runtime.xstream.MapWriter;
import cucumber.util.FixJava;
import cucumber.util.Mapper;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableConverter {
    private final LocalizedXStreams.LocalizedXStream xStream;
    private final ParameterInfo parameterInfo;

    public TableConverter(LocalizedXStreams.LocalizedXStream xStream, ParameterInfo parameterInfo) {
        this.xStream = xStream;
        this.parameterInfo = parameterInfo;
    }

    public <T> T convert(DataTable dataTable, Type type, boolean transposed) {
        if (transposed) {
            dataTable = dataTable.transpose();
        }
        if (type == null || type instanceof Class && ((Class)type).isAssignableFrom(DataTable.class)) {
            return (T)dataTable;
        }
        Type mapKeyType = Utils.mapKeyType(type);
        if (mapKeyType != null) {
            Type mapValueType = Utils.mapValueType(type);
            return (T)this.toMap(dataTable, mapKeyType, mapValueType);
        }
        Type itemType = Utils.listItemType(type);
        if (itemType == null) {
            throw new CucumberException("Not a Map or List type: " + type);
        }
        Type listItemType = Utils.listItemType(itemType);
        if (listItemType != null) {
            return (T)this.toLists(dataTable, listItemType);
        }
        SingleValueConverter singleValueConverter = this.xStream.getSingleValueConverter(itemType);
        if (singleValueConverter != null) {
            return (T)this.toList(dataTable, singleValueConverter);
        }
        if (itemType instanceof Class) {
            if (Map.class.equals((Object)itemType)) {
                return (T)this.toMaps(dataTable, (Type)((Object)String.class), (Type)((Object)String.class));
            }
            return (T)this.toListOfComplexType(dataTable, (Class)itemType);
        }
        return (T)this.toMaps(dataTable, Utils.mapKeyType(itemType), Utils.mapValueType(itemType));
    }

    private <T> List<T> toListOfComplexType(DataTable dataTable, Class<T> itemType) {
        ListOfComplexTypeReader reader = new ListOfComplexTypeReader(itemType, this.convertTopCellsToFieldNames(dataTable), dataTable.cells(1));
        try {
            this.xStream.setParameterInfo(this.parameterInfo);
            List list = Collections.unmodifiableList((List)this.xStream.unmarshal((HierarchicalStreamReader)reader));
            return list;
        }
        catch (AbstractReflectionConverter.UnknownFieldException e) {
            throw new CucumberException(e.getShortMessage());
        }
        catch (AbstractReflectionConverter.DuplicateFieldException e) {
            throw new CucumberException(e.getShortMessage());
        }
        catch (ConversionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw new CucumberException(String.format("Can't assign null value to one of the primitive fields in %s. Please use boxed types.", e.get("class")));
            }
            throw new CucumberException(e);
        }
        finally {
            this.xStream.unsetParameterInfo();
        }
    }

    public <T> List<T> toList(DataTable dataTable, Type itemType) {
        SingleValueConverter itemConverter = this.xStream.getSingleValueConverter(itemType);
        if (itemConverter != null) {
            return this.toList(dataTable, itemConverter);
        }
        if (itemType instanceof Class) {
            return this.toListOfComplexType(dataTable, (Class)itemType);
        }
        throw new CucumberException(String.format("Can't convert DataTable to List<%s>", itemType));
    }

    private <T> List<T> toList(DataTable dataTable, SingleValueConverter itemConverter) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (List<String> row : dataTable.raw()) {
            for (String cell : row) {
                result.add(itemConverter.fromString(cell));
            }
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<List<T>> toLists(DataTable dataTable, Type itemType) {
        try {
            this.xStream.setParameterInfo(this.parameterInfo);
            SingleValueConverter itemConverter = this.xStream.getSingleValueConverter(itemType);
            if (itemConverter == null) {
                throw new CucumberException(String.format("Can't convert DataTable to List<List<%s>>", itemType));
            }
            ArrayList result = new ArrayList();
            for (List<String> row : dataTable.raw()) {
                ArrayList<Object> convertedRow = new ArrayList<Object>();
                for (String cell : row) {
                    convertedRow.add(itemConverter.fromString(cell));
                }
                result.add(Collections.unmodifiableList(convertedRow));
            }
            List list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.xStream.unsetParameterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Map<K, V> toMap(DataTable dataTable, Type keyType, Type valueType) {
        try {
            this.xStream.setParameterInfo(this.parameterInfo);
            SingleValueConverter keyConverter = this.xStream.getSingleValueConverter(keyType);
            SingleValueConverter valueConverter = this.xStream.getSingleValueConverter(valueType);
            if (keyConverter == null || valueConverter == null) {
                throw new CucumberException(String.format("Can't convert DataTable to Map<%s,%s>", keyType, valueType));
            }
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (List<String> row : dataTable.raw()) {
                if (row.size() != 2) {
                    throw new CucumberException("A DataTable can only be converted to a Map when there are 2 columns");
                }
                Object key = keyConverter.fromString(row.get(0));
                Object value = valueConverter.fromString(row.get(1));
                result.put(key, value);
            }
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            this.xStream.unsetParameterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> List<Map<K, V>> toMaps(DataTable dataTable, Type keyType, Type valueType) {
        try {
            this.xStream.setParameterInfo(this.parameterInfo);
            SingleValueConverter keyConverter = this.xStream.getSingleValueConverter(keyType);
            SingleValueConverter valueConverter = this.xStream.getSingleValueConverter(valueType);
            if (keyConverter == null || valueConverter == null) {
                throw new CucumberException(String.format("Can't convert DataTable to List<Map<%s,%s>>", keyType, valueType));
            }
            ArrayList result = new ArrayList();
            List<String> keyStrings = dataTable.topCells();
            ArrayList<Object> keys = new ArrayList<Object>();
            for (String keyString : keyStrings) {
                keys.add(keyConverter.fromString(keyString));
            }
            List<List<String>> valueRows = dataTable.cells(1);
            for (List<String> valueRow : valueRows) {
                LinkedHashMap map = new LinkedHashMap();
                int i = 0;
                for (String cell : valueRow) {
                    map.put(keys.get(i), valueConverter.fromString(cell));
                    ++i;
                }
                result.add(Collections.unmodifiableMap(map));
            }
            List list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.xStream.unsetParameterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable toTable(List<?> objects, String ... columnNames) {
        try {
            this.xStream.setParameterInfo(this.parameterInfo);
            List<String> header = null;
            ArrayList<List<String>> valuesList = new ArrayList<List<String>>();
            for (Object object : objects) {
                CellWriter writer;
                if (this.isListOfSingleValue(object)) {
                    object = new ArrayList((List)object);
                    writer = new ListOfSingleValueWriter();
                } else if (this.isArrayOfSingleValue(object)) {
                    object = new ArrayList<Object>(Arrays.asList((Object[])object));
                    writer = new ListOfSingleValueWriter();
                } else {
                    writer = object instanceof Map ? new MapWriter(Arrays.asList(columnNames)) : new ComplexTypeWriter(Arrays.asList(columnNames));
                }
                this.xStream.marshal(object, (HierarchicalStreamWriter)writer);
                if (header == null) {
                    header = writer.getHeader();
                }
                List<String> values = writer.getValues();
                valuesList.add(values);
            }
            DataTable dataTable = this.createDataTable(header, valuesList);
            return dataTable;
        }
        finally {
            this.xStream.unsetParameterInfo();
        }
    }

    private DataTable createDataTable(List<String> header, List<List<String>> valuesList) {
        ArrayList<PickleRow> gherkinRows = new ArrayList<PickleRow>();
        if (header != null) {
            gherkinRows.add(this.gherkinRow(header));
        }
        for (List<String> values : valuesList) {
            gherkinRows.add(this.gherkinRow(values));
        }
        return new DataTable(new PickleTable(gherkinRows), this);
    }

    private PickleRow gherkinRow(List<String> cells) {
        ArrayList<PickleCell> pickleCells = new ArrayList<PickleCell>(cells.size());
        for (String cell : cells) {
            PickleCell pickleCell = new PickleCell(null, cell);
            pickleCells.add(pickleCell);
        }
        return new PickleRow(pickleCells);
    }

    private List<String> convertTopCellsToFieldNames(DataTable dataTable) {
        final CamelCaseStringConverter mapper = new CamelCaseStringConverter();
        return FixJava.map(dataTable.topCells(), new Mapper<String, String>(){

            @Override
            public String map(String attributeName) {
                return mapper.map(attributeName);
            }
        });
    }

    private boolean isListOfSingleValue(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return !list.isEmpty() && this.xStream.getSingleValueConverter(list.get(0).getClass()) != null;
        }
        return false;
    }

    private boolean isArrayOfSingleValue(Object object) {
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            return array.length > 0 && this.xStream.getSingleValueConverter(array[0].getClass()) != null;
        }
        return false;
    }
}

