/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.DataTable;
import cucumber.api.Scenario;
import cucumber.runtime.Argument;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DefinitionMatch;
import cucumber.runtime.Match;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.table.TableConverter;
import cucumber.runtime.xstream.LocalizedXStreams;
import cucumber.util.FixJava;
import cucumber.util.Mapper;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class StepDefinitionMatch
extends Match
implements DefinitionMatch {
    private final StepDefinition stepDefinition;
    private final transient String featurePath;
    private final transient PickleStep step;
    private final LocalizedXStreams localizedXStreams;

    public StepDefinitionMatch(List<Argument> arguments, StepDefinition stepDefinition, String featurePath, PickleStep step, LocalizedXStreams localizedXStreams) {
        super(arguments, stepDefinition.getLocation(false));
        this.stepDefinition = stepDefinition;
        this.featurePath = featurePath;
        this.step = step;
        this.localizedXStreams = localizedXStreams;
    }

    @Override
    public void runStep(String language, Scenario scenario) throws Throwable {
        try {
            this.stepDefinition.execute(language, this.transformedArgs(this.step, this.localizedXStreams.get(this.localeFor(language))));
        }
        catch (CucumberException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.removeFrameworkFramesAndAppendStepLocation(t, this.getStepLocation());
        }
    }

    @Override
    public void dryRunStep(String language, Scenario scenario) throws Throwable {
    }

    private Object[] transformedArgs(PickleStep step, LocalizedXStreams.LocalizedXStream xStream) {
        Integer parameterCount;
        int argumentCount = this.getArguments().size();
        if (!step.getArgument().isEmpty()) {
            ++argumentCount;
        }
        if ((parameterCount = this.stepDefinition.getParameterCount()) != null && argumentCount != parameterCount) {
            throw this.arityMismatch(parameterCount);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int n = 0;
        for (Argument a : this.getArguments()) {
            ParameterInfo parameterInfo = this.getParameterType(n, (Type)((Object)String.class));
            Object arg = parameterInfo.convert(a.getVal(), xStream);
            result.add(arg);
            ++n;
        }
        if (!step.getArgument().isEmpty()) {
            gherkin.pickles.Argument stepArgument = (gherkin.pickles.Argument)step.getArgument().get(0);
            if (stepArgument instanceof PickleTable) {
                result.add(this.tableArgument((PickleTable)stepArgument, n, xStream));
            } else if (stepArgument instanceof PickleString) {
                ParameterInfo parameterInfo = this.getParameterType(n, (Type)((Object)String.class));
                Object arg = parameterInfo.convert(((PickleString)stepArgument).getContent(), xStream);
                result.add(arg);
            }
        }
        return result.toArray(new Object[result.size()]);
    }

    private ParameterInfo getParameterType(int n, Type argumentType) {
        ParameterInfo parameterInfo = this.stepDefinition.getParameterType(n, argumentType);
        if (parameterInfo == null) {
            parameterInfo = new ParameterInfo(argumentType, null, null, false, null);
        }
        return parameterInfo;
    }

    private Object tableArgument(PickleTable stepArgument, int argIndex, LocalizedXStreams.LocalizedXStream xStream) {
        ParameterInfo parameterInfo = this.getParameterType(argIndex, (Type)((Object)DataTable.class));
        TableConverter tableConverter = new TableConverter(xStream, parameterInfo);
        DataTable table = new DataTable(stepArgument, tableConverter);
        Type type = parameterInfo.getType();
        return tableConverter.convert(table, type, parameterInfo.isTransposed());
    }

    private CucumberException arityMismatch(int parameterCount) {
        List<Argument> arguments = this.createArgumentsForErrorMessage(this.step);
        return new CucumberException(String.format("Arity mismatch: Step Definition '%s' with pattern [%s] is declared with %s parameters. However, the gherkin step has %s arguments %s. \nStep text: %s", this.stepDefinition.getLocation(true), this.stepDefinition.getPattern(), parameterCount, arguments.size(), arguments, this.step.getText()));
    }

    private List<Argument> createArgumentsForErrorMessage(PickleStep step) {
        ArrayList<Argument> arguments = new ArrayList<Argument>(this.getArguments());
        if (!step.getArgument().isEmpty()) {
            gherkin.pickles.Argument stepArgument = (gherkin.pickles.Argument)step.getArgument().get(0);
            if (stepArgument instanceof PickleString) {
                arguments.add(new Argument(-1, "DocString:" + ((PickleString)stepArgument).getContent()));
            } else if (stepArgument instanceof PickleTable) {
                List<List<String>> rows = FixJava.map(((PickleTable)stepArgument).getRows(), new Mapper<PickleRow, List<String>>(){

                    @Override
                    public List<String> map(PickleRow row) {
                        ArrayList<String> raw = new ArrayList<String>(row.getCells().size());
                        for (PickleCell pickleCell : row.getCells()) {
                            raw.add(pickleCell.getValue());
                        }
                        return raw;
                    }
                });
                arguments.add(new Argument(-1, "Table:" + rows.toString()));
            }
        }
        return arguments;
    }

    protected Throwable removeFrameworkFramesAndAppendStepLocation(Throwable error, StackTraceElement stepLocation) {
        int newStackTraceLength;
        StackTraceElement[] stackTraceElements = error.getStackTrace();
        if (stackTraceElements.length == 0 || stepLocation == null) {
            return error;
        }
        for (newStackTraceLength = 1; newStackTraceLength < stackTraceElements.length && !this.stepDefinition.isDefinedAt(stackTraceElements[newStackTraceLength - 1]); ++newStackTraceLength) {
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[newStackTraceLength + 1];
        System.arraycopy(stackTraceElements, 0, newStackTrace, 0, newStackTraceLength);
        newStackTrace[newStackTraceLength] = stepLocation;
        error.setStackTrace(newStackTrace);
        return error;
    }

    private Locale localeFor(String language) {
        String[] languageAndCountry = language.split("-");
        if (languageAndCountry.length == 1) {
            return new Locale(language);
        }
        return new Locale(languageAndCountry[0], languageAndCountry[1]);
    }

    @Override
    public String getPattern() {
        return this.stepDefinition.getPattern();
    }

    public StackTraceElement getStepLocation() {
        return new StackTraceElement("\u273d", this.step.getText(), this.featurePath, StepDefinitionMatch.getStepLine(this.step));
    }

    @Override
    public Match getMatch() {
        return this;
    }

    @Override
    public String getCodeLocation() {
        return this.stepDefinition.getLocation(false);
    }

    public static int getStepLine(PickleStep step) {
        return ((PickleLocation)step.getLocations().get(step.getLocations().size() - 1)).getLine();
    }
}

