/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.HookType;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.Argument;
import cucumber.runtime.formatter.TestSourcesModel;
import gherkin.ast.Background;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.Step;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.net.iharder.Base64;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class JSONFormatter
implements Formatter {
    private String currentFeatureFile;
    private List<Map<String, Object>> featureMaps = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> currentElementsList;
    private Map<String, Object> currentElementMap;
    private Map<String, Object> currentTestCaseMap;
    private List<Map<String, Object>> currentStepsList;
    private Map<String, Object> currentStepOrHookMap;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final NiceAppendable out;
    private final TestSourcesModel testSources = new TestSourcesModel();
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            JSONFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            JSONFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        @Override
        public void receive(TestStepStarted event) {
            JSONFormatter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            JSONFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            JSONFormatter.this.finishReport();
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        @Override
        public void receive(WriteEvent event) {
            JSONFormatter.this.handleWrite(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        @Override
        public void receive(EmbedEvent event) {
            JSONFormatter.this.handleEmbed(event);
        }
    };

    public JSONFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.testCase.getUri())) {
            this.currentFeatureFile = event.testCase.getUri();
            Map<String, Object> currentFeatureMap = this.createFeatureMap(event.testCase);
            this.featureMaps.add(currentFeatureMap);
            this.currentElementsList = (List)currentFeatureMap.get("elements");
        }
        this.currentTestCaseMap = this.createTestCase(event.testCase);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.testCase.getLine())) {
            this.currentElementMap = this.createBackground(event.testCase);
            this.currentElementsList.add(this.currentElementMap);
        } else {
            this.currentElementMap = this.currentTestCaseMap;
        }
        this.currentElementsList.add(this.currentTestCaseMap);
        this.currentStepsList = (List)this.currentElementMap.get("steps");
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (!event.testStep.isHook()) {
            if (this.isFirstStepAfterBackground(event.testStep)) {
                this.currentElementMap = this.currentTestCaseMap;
                this.currentStepsList = (List)this.currentElementMap.get("steps");
            }
            this.currentStepOrHookMap = this.createTestStep(event.testStep);
            this.currentStepsList.add(this.currentStepOrHookMap);
        } else {
            this.currentStepOrHookMap = this.createHookStep(event.testStep);
            this.addHookStepToTestCaseMap(this.currentStepOrHookMap, event.testStep.getHookType());
        }
    }

    private void handleWrite(WriteEvent event) {
        this.addOutputToHookMap(event.text);
    }

    private void handleEmbed(EmbedEvent event) {
        this.addEmbeddingToHookMap(event.data, event.mimeType);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        this.currentStepOrHookMap.put("match", this.createMatchMap(event.testStep, event.result));
        this.currentStepOrHookMap.put("result", this.createResultMap(event.result));
    }

    private void finishReport() {
        this.out.append(this.gson.toJson(this.featureMaps));
        this.out.close();
    }

    private Map<String, Object> createFeatureMap(TestCase testCase) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>();
        featureMap.put("uri", testCase.getUri());
        featureMap.put("elements", new ArrayList());
        Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            featureMap.put("keyword", feature.getKeyword());
            featureMap.put("name", feature.getName());
            featureMap.put("description", feature.getDescription() != null ? feature.getDescription() : "");
            featureMap.put("line", feature.getLocation().getLine());
            featureMap.put("id", TestSourcesModel.convertToId(feature.getName()));
        }
        return featureMap;
    }

    private Map<String, Object> createTestCase(TestCase testCase) {
        HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
        testCaseMap.put("name", testCase.getName());
        testCaseMap.put("line", testCase.getLine());
        testCaseMap.put("type", "scenario");
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            testCaseMap.put("id", TestSourcesModel.calculateId(astNode));
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            testCaseMap.put("keyword", scenarioDefinition.getKeyword());
            testCaseMap.put("description", scenarioDefinition.getDescription() != null ? scenarioDefinition.getDescription() : "");
        }
        testCaseMap.put("steps", new ArrayList());
        if (!testCase.getTags().isEmpty()) {
            ArrayList tagList = new ArrayList();
            for (PickleTag tag : testCase.getTags()) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                tagMap.put("name", tag.getName());
                tagList.add(tagMap);
            }
            testCaseMap.put("tags", tagList);
        }
        return testCaseMap;
    }

    private Map<String, Object> createBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
            testCaseMap.put("name", background.getName());
            testCaseMap.put("line", background.getLocation().getLine());
            testCaseMap.put("type", "background");
            testCaseMap.put("keyword", background.getKeyword());
            testCaseMap.put("description", background.getDescription() != null ? background.getDescription() : "");
            testCaseMap.put("steps", new ArrayList());
            return testCaseMap;
        }
        return null;
    }

    private boolean isFirstStepAfterBackground(TestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        return astNode != null && this.currentElementMap != this.currentTestCaseMap && !TestSourcesModel.isBackgroundStep(astNode);
    }

    private Map<String, Object> createTestStep(TestStep testStep) {
        TestSourcesModel.AstNode astNode;
        HashMap<String, Object> stepMap = new HashMap<String, Object>();
        stepMap.put("name", testStep.getStepText());
        stepMap.put("line", testStep.getStepLine());
        if (!testStep.getStepArgument().isEmpty()) {
            gherkin.pickles.Argument argument = testStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                stepMap.put("doc_string", this.createDocStringMap(argument));
            } else if (argument instanceof PickleTable) {
                stepMap.put("rows", this.createDataTableList(argument));
            }
        }
        if ((astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine())) != null) {
            Step step = (Step)astNode.node;
            stepMap.put("keyword", step.getKeyword());
        }
        return stepMap;
    }

    private Map<String, Object> createDocStringMap(gherkin.pickles.Argument argument) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        PickleString docString = (PickleString)argument;
        docStringMap.put("value", docString.getContent());
        docStringMap.put("line", docString.getLocation().getLine());
        return docStringMap;
    }

    private List<Map<String, Object>> createDataTableList(gherkin.pickles.Argument argument) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (PickleRow row : ((PickleTable)argument).getRows()) {
            HashMap<String, List<String>> rowMap = new HashMap<String, List<String>>();
            rowMap.put("cells", this.createCellList(row));
            rowList.add(rowMap);
        }
        return rowList;
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private Map<String, Object> createHookStep(TestStep testStep) {
        return new HashMap<String, Object>();
    }

    private void addHookStepToTestCaseMap(Map<String, Object> currentStepOrHookMap, HookType hookType) {
        if (!this.currentTestCaseMap.containsKey(hookType.toString())) {
            this.currentTestCaseMap.put(hookType.toString(), new ArrayList());
        }
        ((List)this.currentTestCaseMap.get(hookType.toString())).add(currentStepOrHookMap);
    }

    private void addOutputToHookMap(String text) {
        if (!this.currentStepOrHookMap.containsKey("output")) {
            this.currentStepOrHookMap.put("output", new ArrayList());
        }
        ((List)this.currentStepOrHookMap.get("output")).add(text);
    }

    private void addEmbeddingToHookMap(byte[] data, String mimeType) {
        if (!this.currentStepOrHookMap.containsKey("embeddings")) {
            this.currentStepOrHookMap.put("embeddings", new ArrayList());
        }
        Map<String, Object> embedMap = this.createEmbeddingMap(data, mimeType);
        ((List)this.currentStepOrHookMap.get("embeddings")).add(embedMap);
    }

    private Map<String, Object> createEmbeddingMap(byte[] data, String mimeType) {
        HashMap<String, Object> embedMap = new HashMap<String, Object>();
        embedMap.put("mime_type", mimeType);
        embedMap.put("data", Base64.encodeBytes((byte[])data));
        return embedMap;
    }

    private Map<String, Object> createMatchMap(TestStep testStep, Result result) {
        HashMap<String, Object> matchMap = new HashMap<String, Object>();
        if (!testStep.getDefinitionArgument().isEmpty()) {
            ArrayList argumentList = new ArrayList();
            for (Argument argument : testStep.getDefinitionArgument()) {
                HashMap<String, Object> argumentMap = new HashMap<String, Object>();
                argumentMap.put("val", argument.getVal());
                argumentMap.put("offset", argument.getOffset());
                argumentList.add(argumentMap);
            }
            matchMap.put("arguments", argumentList);
        }
        if (!result.is(Result.Type.UNDEFINED)) {
            matchMap.put("location", testStep.getCodeLocation());
        }
        return matchMap;
    }

    private Map<String, Object> createResultMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("status", result.getStatus().lowerCaseName());
        if (result.getErrorMessage() != null) {
            resultMap.put("error_message", result.getErrorMessage());
        }
        if (result.getDuration() != null && result.getDuration() != 0L) {
            resultMap.put("duration", result.getDuration());
        }
        return resultMap;
    }
}

