/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

public class CompareUtils {
    public static final double ERROR = 1.0E-6;

    public static int compare(Object data1, Object data2) {
        if (data1 == null ^ data2 == null) {
            return data1 == null ? -1 : 1;
        }
        if (data1 != null && data2 != null) {
            return ((Comparable)data1).compareTo(data2);
        }
        return 0;
    }

    public static int compare(long a, long b) {
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public static int compareUnsigned(long a, long b) {
        if (a < 0L && b >= 0L) {
            return 1;
        }
        if (a >= 0L && b < 0L) {
            return -1;
        }
        return CompareUtils.compare(a, b);
    }

    public static int compare(double a, double b) {
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(Object data1, Object data2) {
        if (data1 == null) {
            return data2 == null;
        }
        if (data2 == null) {
            return false;
        }
        return data1 == data2 || data1.equals(data2);
    }

    public static boolean nullSafeEquals(Object left, Object right) {
        if (null == left) {
            return null == right;
        }
        return left.equals(right);
    }

    public static boolean EQ(double x, double y) {
        return CompareUtils.doubleEquals(x, y);
    }

    public static boolean doubleEquals(double x, double y) {
        return CompareUtils.doubleEquals(x, y, 1.0E-6);
    }

    public static boolean doubleEqualsZero(double x) {
        return CompareUtils.doubleEqualsZero(x, 1.0E-6);
    }

    public static boolean doubleEquals(double x, double y, double tolerance) {
        return Double.isNaN(x) && Double.isNaN(y) || Math.abs(x - y) < tolerance;
    }

    public static boolean doubleEqualsZero(double x, double tolerance) {
        return Math.abs(x) < tolerance;
    }

    public static boolean EQ2(double x, double y) {
        return CompareUtils.doubleEquals2(x, y, 1.0E-6);
    }

    public static boolean doubleEquals2(double x, double y) {
        return CompareUtils.doubleEquals2(x, y, 1.0E-6);
    }

    public static boolean doubleEquals2(double x, double y, double tolerance) {
        return Double.compare(x, y) == 0 || Math.abs(x - y) < tolerance;
    }

    public static boolean NE(double x, double y) {
        return CompareUtils.doubleNotEquals(x, y);
    }

    public static boolean doubleNotEquals(double x, double y) {
        return CompareUtils.doubleNotEquals(x, y, 1.0E-6);
    }

    public static boolean doubleNotEquals(double x, double y, double tolerance) {
        boolean isNaNx = Double.isNaN(x);
        boolean isNaNy = Double.isNaN(y);
        if (!isNaNx && !isNaNy) {
            return Math.abs(x - y) > tolerance;
        }
        return isNaNx ^ isNaNy;
    }

    public static boolean NE2(double x, double y) {
        return !CompareUtils.doubleEquals2(x, y, 1.0E-6);
    }

    public static boolean doubleNotEquals2(double x, double y) {
        return !CompareUtils.doubleEquals2(x, y, 1.0E-6);
    }

    public static boolean doubleNotEquals2(double x, double y, double tolerance) {
        return Double.compare(x, y) != 0 && !(Math.abs(x - y) < tolerance);
    }

    public static boolean GT(double x, double y) {
        return CompareUtils.doubleGreater(x, y);
    }

    public static boolean doubleGreater(double x, double y) {
        return x - y > 1.0E-6;
    }

    public static boolean doubleGreater(double x, double y, double tolerance) {
        return x - y > tolerance;
    }

    public static boolean GE(double x, double y) {
        return CompareUtils.doubleGreaterEqual(x, y);
    }

    public static boolean doubleGreaterEqual(double x, double y) {
        return y - x < 1.0E-6;
    }

    public static boolean doubleGreaterEqual(double x, double y, double tolerance) {
        return y - x < tolerance;
    }

    public static boolean doubleLess(double x, double y, double tolerance) {
        return y - x > tolerance;
    }

    public static boolean LT(double x, double y) {
        return CompareUtils.doubleLess(x, y);
    }

    public static boolean doubleLess(double x, double y) {
        return y - x > 1.0E-6;
    }

    public static boolean doubleLessEqual(double x, double y, double tolerance) {
        return x - y < tolerance;
    }

    public static boolean LE(double x, double y) {
        return CompareUtils.doubleLessEqual(x, y);
    }

    public static boolean doubleLessEqual(double x, double y) {
        return x - y < 1.0E-6;
    }

    public static int doubleCompare(double d1, double d2) {
        if (CompareUtils.doubleEquals(d1, d2)) {
            return 0;
        }
        return Double.compare(d1, d2);
    }
}

