/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.LockFreeArrayQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class FIFOMutex {
    private final LockFreeArrayQueue<Thread> threads = new LockFreeArrayQueue(10);
    private final AtomicReference<Thread> leader = new AtomicReference<Object>(null);

    public void lock() {
        boolean wasInterrupted = false;
        Thread me = Thread.currentThread();
        while (!this.threads.enqueue(me)) {
        }
        int spins = 0;
        boolean peekNotMe = true;
        while (peekNotMe && (peekNotMe = this.threads.peek() != me) || !this.leader.compareAndSet(null, me)) {
            if (++spins % 1000 != 0) continue;
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        Thread t = this.threads.dequeue();
        if (t != me) {
            throw new IllegalStateException("Failed to dequeue myself, got " + t);
        }
        if (wasInterrupted) {
            me.interrupt();
        }
    }

    public void unlock() {
        Thread me = Thread.currentThread();
        if (!this.leader.compareAndSet(me, null)) {
            throw new IllegalStateException("wrong thread called handoff");
        }
        LockSupport.unpark(this.threads.peek());
    }

    public Thread getOwner() {
        return this.leader.get();
    }
}

