/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LowGarbageArrayIntegerMap<T>
extends HashMap<Integer, T> {
    private Object[] m_values = new Object[500];

    @Override
    public T get(Object key) {
        if (key instanceof Integer) {
            int nIndex = (Integer)key;
            if (nIndex < 0 || nIndex >= this.m_values.length) {
                return null;
            }
            return (T)this.m_values[nIndex];
        }
        return null;
    }

    @Override
    public T put(Integer key, T value) {
        if (null != key) {
            Require.geqZero(key, "nIndex");
            if (key >= this.m_values.length) {
                this.m_values = ArrayUtil.extend(this.m_values, (int)key, Object.class);
            }
            Object oldValue = this.m_values[key];
            this.m_values[key.intValue()] = value;
            return (T)oldValue;
        }
        throw Require.valueNeverOccurs(key, "key");
    }

    @Override
    public T remove(Object key) {
        if (key instanceof Integer) {
            int nIndex = (Integer)key;
            if (nIndex < 0 || nIndex >= this.m_values.length) {
                return null;
            }
            Object oldValue = this.m_values[nIndex];
            this.m_values[nIndex] = null;
            return (T)oldValue;
        }
        return null;
    }

    @Override
    public int size() {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public boolean isEmpty() {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public boolean containsKey(Object key) {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends T> m) {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public void clear() {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public boolean containsValue(Object value) {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public Object clone() {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public Set<Integer> keySet() {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public Collection<T> values() {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        throw Assert.statementNeverExecuted();
    }
}

