/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.verify.Assert;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LowGarbageArrayList<E>
extends ArrayList<E> {
    private final Itr m_itr = new Itr();

    @Override
    public Iterator<E> iterator() {
        return this.m_itr.reset();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw Assert.statementNeverExecuted("Not yet implemented.");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw Assert.statementNeverExecuted("Not yet implemented.");
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet;
        int expectedModCount;

        private Itr() {
        }

        private Itr reset() {
            this.cursor = 0;
            this.lastRet = -1;
            this.expectedModCount = LowGarbageArrayList.this.modCount;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != LowGarbageArrayList.this.size();
        }

        @Override
        public E next() {
            this.checkForCoModification();
            try {
                Object next = LowGarbageArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForCoModification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForCoModification();
            try {
                LowGarbageArrayList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = LowGarbageArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForCoModification() {
            if (LowGarbageArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

