/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;

public class RAPriQueue<T> {
    private T[] queue;
    private final Adapter<? super T> adapter;
    private final Class<? super T> elementClass;
    private int size = 0;

    public RAPriQueue(int initialSize, Adapter<? super T> adapter, Class<? super T> elementClass) {
        this.queue = (Object[])Array.newInstance(elementClass, initialSize + 1);
        this.adapter = adapter;
        this.elementClass = elementClass;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.queue, null);
        this.size = 0;
    }

    public void enter(T el) {
        int k = this.adapter.getPos(el);
        if (k <= 0) {
            if (++this.size == this.queue.length) {
                Object[] newQueue = (Object[])Array.newInstance(this.elementClass, 2 * this.queue.length);
                System.arraycopy(this.queue, 0, newQueue, 0, this.size);
                this.queue = newQueue;
            }
            this.queue[this.size] = el;
            this.adapter.setPos(el, this.size);
            this.fixUp(this.size);
        } else {
            assert (this.queue[k] == el);
            this.fixDown(k);
            this.fixUp(k);
        }
    }

    public T top() {
        return this.queue[1];
    }

    public T removeTop() {
        T el = this.queue[1];
        if (el != null) {
            this.adapter.setPos(el, 0);
            if (--this.size == 0) {
                this.queue[1] = null;
            } else {
                this.queue[1] = this.queue[this.size + 1];
                this.queue[this.size + 1] = null;
                this.adapter.setPos(this.queue[1], 1);
                this.fixDown(1);
            }
        }
        return el;
    }

    public void remove(T el) {
        int k = this.adapter.getPos(el);
        if (k != 0) {
            assert (this.queue[k] == el);
            this.adapter.setPos(el, 0);
            if (k == this.size) {
                this.queue[this.size--] = null;
            } else {
                this.queue[k] = this.queue[this.size];
                this.adapter.setPos(this.queue[k], k);
                this.queue[this.size--] = null;
                this.fixDown(k);
                this.fixUp(k);
            }
        }
    }

    private void fixUp(int k) {
        int j;
        T parent;
        T el;
        if (k > 1 && this.adapter.less(el = this.queue[k], parent = this.queue[j = k >> 1])) {
            this.queue[k] = parent;
            this.adapter.setPos(parent, k);
            k = j;
            j = k >> 1;
            while (k > 1 && this.adapter.less(el, parent = this.queue[j])) {
                this.queue[k] = parent;
                this.adapter.setPos(parent, k);
                k = j;
                j = k >> 1;
            }
            this.queue[k] = el;
            this.adapter.setPos(el, k);
        }
    }

    private void fixDown(int k) {
        int j = k << 1;
        if (j <= this.size) {
            T child2;
            T el = this.queue[k];
            T child = this.queue[j];
            if (j < this.size && this.adapter.less(child2 = this.queue[j + 1], child)) {
                child = child2;
                ++j;
            }
            if (this.adapter.less(child, el)) {
                this.queue[k] = child;
                this.adapter.setPos(child, k);
                k = j;
                j = k << 1;
                while (j <= this.size) {
                    child = this.queue[j];
                    if (j < this.size && this.adapter.less(child2 = this.queue[j + 1], child)) {
                        child = child2;
                        ++j;
                    }
                    if (!this.adapter.less(child, el)) break;
                    this.queue[k] = child;
                    this.adapter.setPos(child, k);
                    k = j;
                    j = k << 1;
                }
                this.queue[k] = el;
                this.adapter.setPos(el, k);
            }
        }
    }

    public int dump(T[] result, int startIndex) {
        for (int i = 0; i < this.size; ++i) {
            result[startIndex++] = this.queue[i + 1];
        }
        return startIndex;
    }

    public T get(int index) {
        return index < this.size ? (T)this.queue[index + 1] : null;
    }

    public <T2> int dump(T2[] result, int startIndex, Function<T, T2> f) {
        for (int i = 0; i < this.size; ++i) {
            result[startIndex++] = f.apply(this.queue[i + 1]);
        }
        return startIndex;
    }

    boolean testInvariantAux(int i, String what) {
        if (i <= this.size) {
            if (this.adapter.getPos(this.queue[i]) != i) {
                System.err.println(what + ": queue[" + i + "].tqPos=" + this.adapter.getPos(this.queue[i]) + " != " + i);
            }
            if (!this.testInvariantAux(i * 2, what)) {
                return false;
            }
            if (!this.testInvariantAux(i * 2 + 1, what)) {
                return false;
            }
            if (i > 1 && this.adapter.less(this.queue[i], this.queue[i / 2])) {
                System.err.println(what + ": child[" + i + "]=" + this.queue[i] + " < parent[" + i / 2 + "]=" + this.queue[i / 2]);
                return false;
            }
        }
        return true;
    }

    boolean testInvariant(String what) {
        boolean result = this.testInvariantAux(1, what);
        if (result) {
            for (int i = this.size + 1; i < this.queue.length; ++i) {
                if (this.queue[i] == null) continue;
                System.err.println(what + ": size = " + this.size + ", child[" + i + "]=" + this.queue[i] + " != null");
                result = false;
            }
        }
        return result;
    }

    public static interface Adapter<T> {
        public boolean less(T var1, T var2);

        public void setPos(T var1, int var2);

        public int getPos(T var1);
    }
}

