/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class WeakReferenceManager<T> {
    private final List<WeakReference<T>> refs;

    public WeakReferenceManager() {
        this(true);
    }

    public WeakReferenceManager(boolean useCowList) {
        this.refs = useCowList ? new CopyOnWriteArrayList() : new ArrayList();
    }

    public void add(T item) {
        this.refs.add(new WeakReference<T>(item));
    }

    public void remove(T item) {
        this.refs.removeIf(l -> l.get() == null || l.get() == item);
    }

    public void removeAll(Collection<T> items) {
        this.refs.removeIf(l -> l.get() == null || items.contains(l.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValidReference(Consumer<T> proc) {
        if (!this.refs.isEmpty()) {
            ArrayList<WeakReference<T>> expiredRefs = new ArrayList<WeakReference<T>>();
            try {
                for (WeakReference<T> ref : this.refs) {
                    Object item = ref.get();
                    if (item != null) {
                        proc.accept(item);
                        continue;
                    }
                    expiredRefs.add(ref);
                }
            }
            finally {
                this.refs.removeAll(expiredRefs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirst(Predicate<T> test) {
        if (!this.refs.isEmpty()) {
            ArrayList<WeakReference<T>> expiredRefs = new ArrayList<WeakReference<T>>();
            try {
                for (WeakReference<T> ref : this.refs) {
                    Object item = ref.get();
                    if (item != null) {
                        if (!test.test(item)) continue;
                        Object t = item;
                        return t;
                    }
                    expiredRefs.add(ref);
                }
            }
            finally {
                this.refs.removeAll(expiredRefs);
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.refs.isEmpty();
    }

    public void clear() {
        this.refs.clear();
    }
}

