/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.array;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.Copyable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FastCharArray
implements Externalizable,
Copyable<FastCharArray> {
    private static final char[] EMPTY = new char[0];
    private int length = 0;
    private char[] array;

    public FastCharArray() {
        this(0);
    }

    public FastCharArray(int initialSize) {
        this.array = initialSize > 0 ? new char[initialSize] : EMPTY;
    }

    public FastCharArray(char[] initValues) {
        this();
        this.add(initValues, 0, initValues.length);
    }

    public void add(char t) {
        this.array = ArrayUtil.put(this.array, this.length, t);
        ++this.length;
    }

    public void add(char[] t, int startIndex, int len) {
        this.array = ArrayUtil.put(this.array, this.length, t, startIndex, len);
        this.length += len;
    }

    public void quickReset() {
        this.length = 0;
    }

    public void normalReset(char resetValue) {
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = resetValue;
        }
        this.length = 0;
    }

    public void fullReset(char resetValue) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = resetValue;
        }
        this.length = 0;
    }

    public void arrayReset() {
        this.length = 0;
        this.array = new char[0];
    }

    public int getLength() {
        return this.length;
    }

    public char[] getUnsafeArray() {
        return this.array;
    }

    public void removeThisIndex(int index) {
        if (index >= this.length) {
            throw new IllegalArgumentException("you tried to remove this index: " + index + " when the array is only this long: " + this.length);
        }
        if (index < 0) {
            throw new IllegalArgumentException("you tried to remove this index: " + index + " when we can only remove positive indices");
        }
        for (int i = index; i < this.length; ++i) {
            this.array[i] = this.array[i + 1];
        }
        --this.length;
    }

    @Override
    public void copyValues(FastCharArray other) {
        if (other != this) {
            this.length = other.length;
            this.array = ArrayUtil.ensureSizeNoCopy(this.array, this.length);
            System.arraycopy(other.array, 0, this.array, 0, this.length);
        }
    }

    public FastCharArray clone() {
        FastCharArray clone = new FastCharArray();
        clone.copyValues(this);
        return clone;
    }

    @Override
    public FastCharArray safeClone() {
        return this.clone();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeChar(this.array[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.quickReset();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this.add(in.readChar());
        }
    }

    public String toString() {
        return this.toStringXml("");
    }

    public String toStringXml(String pre) {
        StringBuilder msg = new StringBuilder();
        String extra = "   ";
        msg.append(pre).append("<FastCharArray>\n");
        for (int i = 0; i < this.array.length; ++i) {
            msg.append(pre).append(extra).append("<index>").append(i).append("</index><length>").append(this.length).append("</length><entry>").append(this.array[i]).append("</entry>\n");
        }
        msg.append(pre).append("</FastCharArray>\n");
        return msg.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastCharArray)) {
            return false;
        }
        FastCharArray that = (FastCharArray)o;
        if (this.length != that.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] == that.array[i]) continue;
            return false;
        }
        return true;
    }
}

