/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.cache;

import gnu.trove.impl.PrimeFinder;
import io.deephaven.base.MathUtil;
import io.deephaven.base.verify.Require;
import io.deephaven.hash.KeyedObjectKey;
import java.util.Random;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class KeyedObjectCache<KEY_TYPE, VALUE_TYPE> {
    private final KeyedObjectKey<KEY_TYPE, VALUE_TYPE> keyDefinition;
    private final Consumer<VALUE_TYPE> postEvictionProcedure;
    private final Random random;
    private final VALUE_TYPE[] storage;
    private final int[] probedSlots;

    public KeyedObjectCache(int capacity, int probeSequenceLength, KeyedObjectKey<KEY_TYPE, VALUE_TYPE> keyDefinition, @Nullable Consumer<VALUE_TYPE> postEvictionProcedure, Random random) {
        Require.gtZero(capacity, "capacity");
        Require.inRange(probeSequenceLength, "probeSequenceLength", capacity / 2, "capacity / 2");
        int primeCapacity = PrimeFinder.nextPrime((int)capacity);
        this.storage = new Object[primeCapacity];
        int powerOf2ProbeSequenceLength = 1 << MathUtil.ceilLog2(probeSequenceLength);
        this.probedSlots = new int[powerOf2ProbeSequenceLength];
        this.keyDefinition = Require.neqNull(keyDefinition, "keyDefinition");
        this.postEvictionProcedure = postEvictionProcedure;
        this.random = Require.neqNull(random, "random");
    }

    public final int getCapacity() {
        return this.storage.length;
    }

    final int getProbeSequenceLength() {
        return this.probedSlots.length;
    }

    public final VALUE_TYPE get(KEY_TYPE key) {
        int hashCode = this.keyDefinition.hashKey(key) & Integer.MAX_VALUE;
        int slot = hashCode % this.storage.length;
        VALUE_TYPE candidate = this.storage[slot];
        if (candidate == null || this.keyDefinition.equalKey(key, candidate)) {
            return candidate;
        }
        int probeInterval = this.computeProbeInterval(hashCode);
        for (int psi = 1; psi < this.probedSlots.length; ++psi) {
            if ((slot -= probeInterval) < 0) {
                slot += this.storage.length;
            }
            if ((candidate = this.storage[slot]) != null && !this.keyDefinition.equalKey(key, candidate)) continue;
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VALUE_TYPE putIfAbsent(VALUE_TYPE value) {
        Object key = this.keyDefinition.getKey(value);
        int hashCode = this.keyDefinition.hashKey(key) & Integer.MAX_VALUE;
        int slot = hashCode % this.storage.length;
        VALUE_TYPE[] VALUE_TYPEArray = this.storage;
        synchronized (this.storage) {
            VALUE_TYPE candidate = this.storage[slot];
            if (candidate == null) {
                this.storage[slot] = value;
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return value;
            }
            if (this.keyDefinition.equalKey(key, candidate)) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return candidate;
            }
            this.probedSlots[0] = slot;
            int probeInterval = this.computeProbeInterval(hashCode);
            for (int psi = 1; psi < this.probedSlots.length; ++psi) {
                if ((slot -= probeInterval) < 0) {
                    slot += this.storage.length;
                }
                if ((candidate = this.storage[slot]) == null) {
                    this.storage[slot] = value;
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return value;
                }
                if (this.keyDefinition.equalKey(key, candidate)) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return candidate;
                }
                this.probedSlots[psi] = slot;
            }
            int slotToEvict = this.probedSlots[this.random.nextInt(this.probedSlots.length)];
            VALUE_TYPE evictedValue = this.storage[slotToEvict];
            this.storage[slotToEvict] = value;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (this.postEvictionProcedure != null) {
                this.postEvictionProcedure.accept(evictedValue);
            }
            return value;
        }
    }

    private int computeProbeInterval(int hashCode) {
        return 1 + hashCode % (this.storage.length - 2);
    }
}

