/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.cache;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import org.jetbrains.annotations.NotNull;

public class RetentionCache<TYPE> {
    private final TObjectIntMap<TYPE> retainedObjectToReferenceCount = new TObjectIntCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE, 10, 0.5f, 0);

    public synchronized TYPE retain(@NotNull TYPE referent) {
        this.retainedObjectToReferenceCount.put(referent, this.retainedObjectToReferenceCount.get(referent) + 1);
        return referent;
    }

    public synchronized void forget(@NotNull TYPE referent) {
        int referenceCount = this.retainedObjectToReferenceCount.get(referent);
        if (referenceCount == 1) {
            this.retainedObjectToReferenceCount.remove(referent);
        } else {
            this.retainedObjectToReferenceCount.put(referent, referenceCount - 1);
        }
    }

    public synchronized void forgetAll() {
        this.retainedObjectToReferenceCount.clear();
    }
}

