/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.queue;

import io.deephaven.base.UnfairSemaphore;
import io.deephaven.base.queue.ProducerConsumer;
import io.deephaven.base.verify.Assert;

public class ProducerConsumerWithTake<T>
implements ProducerConsumer<T> {
    private final ProducerConsumer<T> producerConsumer;
    private final UnfairSemaphore semaphore;

    public ProducerConsumerWithTake(ProducerConsumer<T> producerConsumer) {
        this.producerConsumer = producerConsumer;
        this.semaphore = new UnfairSemaphore(0, 1000);
    }

    @Override
    public boolean produce(T t) {
        if (this.producerConsumer.produce(t)) {
            this.semaphore.release(1);
            return true;
        }
        return false;
    }

    @Override
    public T consume() {
        if (this.semaphore.tryAcquire(1)) {
            T t = this.producerConsumer.consume();
            Assert.neqNull(t, "t");
            return t;
        }
        return null;
    }

    public T take() {
        this.semaphore.acquire(1);
        T t = this.producerConsumer.consume();
        Assert.neqNull(t, "t");
        return t;
    }

    public int size() {
        return this.semaphore.availablePermits();
    }
}

